/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef DBBACKENDS_ALLBACKENDS_H
#define DBBACKENDS_ALLBACKENDS_H

namespace EventProcessors { class iEventProcessor; }
namespace EventTypes { class iEvent; }

class NumberToNameLookup;
class Settings;
template <typename T1> class QList;

namespace DBBackends
{
	class iDBBackend;

	class AllBackends
	{
	public:
		AllBackends(const Settings &settings);

		const QList<iDBBackend *> & Backends() const;
		void Process(EventProcessors::iEventProcessor &eventProcessor);
		void Insert(EventTypes::iEvent &event, const NumberToNameLookup &numberToNameLookup);

	public:
		const Settings &CurrentSettings() const { return m_Settings; }

	private:
		const Settings &m_Settings;
	};
}

#endif // DBBACKENDS_ALLBACKENDS_H
