/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef ATTACHMENTS_H
#define ATTACHMENTS_H

#include <QList>
#include <QSharedPointer>

#include "Attachment.h"

#include "iHashable.h"

class _GList;
typedef struct _GList GList;

class AttachmentCollection : public QList<QSharedPointer<Attachment> >, public iHashable
{
public:
	AttachmentCollection() : QList<QSharedPointer<Attachment> >() {}
	AttachmentCollection( const QList<QSharedPointer<Attachment> > other) : QList<QSharedPointer<Attachment> >(other) {}

	GList *toRTComAttachments() const;
	static void freeRTComContents(GList &attachments);

	void append(Attachment *attachment)
	{
		QList<QSharedPointer<Attachment> >::append(QSharedPointer<Attachment>(attachment));
	}

	const uint HashCode() const;
};

#endif // ATTACHMENTS_H
