/*
 * QvernoteStorageQueries.h
 *
 *  Created on: Jun 13, 2010
 *      Author: alexr
 */

#ifndef QVERNOTESTORAGEQUERIES_H_
#define QVERNOTESTORAGEQUERIES_H_

#define PREPARE_NOTEBOOK_SCRIPT	\
	"create table notebooks ( " \
		"guid varchar(255) primary key, " \
		"name varchar(255), " \
		"updateSequenceNum integer, "\
		"defaultNotebook smallint, " \
		"serviceCreated integer, " \
		"serviceUpdated integer, " \
		"published integer )"

#define PREPARE_NOTE_SCRIPT \
	"create table notes ( " \
			"guid varchar(255) primary key, " \
			"title varchar(255), " \
			"content CBLOB, " \
			"contentHash varchar(64), " \
			"contentLength integer, " \
			"created integer, " \
			"updated integer, " \
			"deleted integer, " \
			"active integer, " \
			"updateSequenceNum integer, " \
			"notebookGuid varchar(255), " \
			"foreign key (notebookGuid) references notebooks(guid) ON DELETE CASCADE )"

#define PREPARE_TAG2NOTE_SCRIPT \
	"create table notetags ( " \
			"tagid varchar(255), " \
			"noteid varchar(255) )"

#define PREPARE_NOTE_ATTRIB_SCRIPT \
	"create table noteattributes ( " \
			"noteid varchar(255), " \
			"subjectDate integer, " \
			"latitude real, " \
			"longitude real, " \
			"altitude real, " \
			"author varchar(255), " \
			"source varchar(255), " \
			"sourceURL varchar(255), " \
			"sourceApplication varchar(255)," \
			"foreign key (noteid) references notes(guid) ON DELETE CASCADE )"

#define PREPARE_TAG_SCRIPT \
	"create table tags ( " \
			"guid varchar(255) primary key, " \
			"name varchar(255), " \
			"parentGuid varchar(255), " \
			"updateSequenceNum integer )"

#define PREPARE_SAVEDSEARCH_SCRIPT \
	"create table savedsearches ( " \
			"guid varchar(255) primary key, " \
			"name varchar(255), " \
			"query varchar(255), " \
			"format integer, " \
			"updateSequenceNum integer )"

#define PREPARE_RESOURCE_SCRIPT \
	"create table resources ( " \
			"guid varchar(255) primary key, " \
			"noteGuid varchar(255), " \
			"mime varchar(255), " \
			"width integer, " \
			"height integer, " \
			"duration integer, " \
			"active integer, " \
			"updateSequenceNum integer, " \
			"foreign key (noteGuid) references notes(guid) ON DELETE CASCADE )"

/*
 * Data can be of types:
 *
 * Resource = 0
 * Recognition = 1
 * Alternate = 2
 */
#define PREPARE_DATATAB_SCRIPT \
	"create table data ( " \
			"resourceid varchar(255), " \
			"type integer, "		\
			"bodyHash varchar(255), " \
			"size integer, " \
			"body BLOB, " \
			"foreign key (resourceid) references resources(guid) ON DELETE CASCADE )"

#define PREPARE_RESOURCE_ATTRIB_SCRIPT \
	"create table resourceattrib ( " \
			"resourceid varchar(255), " \
			"sourceURL varchar(255), " \
			"timestamp integer, " \
			"latitude real, " \
			"longitude real, " \
			"altitude real, " \
			"cameraMake varchar(255), " \
			"cameraModel varchar(255), " \
			"clientWillIndex integer, " \
			"fileName varchar(255), " \
			"attachment integer, "\
			"foreign key (resourceid) references resources(guid) ON DELETE CASCADE )"

//#define DELETE_NOTE_TAG "delete * from notetags where noteid = ?"
//#define DELETE_NOTE_ATTR "delete * from noteattributes where noteid = ?"
//#define DELETE_NOTE_RESOURCES "delete * from resources,data,resourceattrib where resources.noteGuid = ? and data.resourceid = resources.guid and resourceattrib.resourceid = resources.guid"
#define INSERT_NOTEBOOK "insert into notebooks (guid, name, updateSequenceNum, defaultNotebook, serviceCreated, serviceUpdated, published)" \
	"values (?, ?, ?, ?, ?, ?, ?)"

#define DELETE_NOTE "delete from notes where guid = ?"

#define INSERT_NOTETAG "insert into notetags (tagid, noteid) values (?, ?)"
#define INSERT_NOTE_ATTRIB \
	"insert into noteattributes (noteid, subjectDate, latitude, longitude, altitude, author, source, sourceURL, sourceApplication)" \
	"values (?, ?, ?, ?, ?, ?, ?, ?, ?)"
#define INSERT_NOTE \
	"insert into notes (guid, title, content, contentHash, contentLength, created, updated, deleted, active, updateSequenceNum, notebookGuid)" \
	"values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"

#define INSERT_DATA	"insert into data (resourceid, type, bodyHash, size, body) values (?, ?, ?, ?, ?)"
#define INSERT_RESOURCE_ATTRIB \
		"insert into resourceattrib (resourceid, sourceURL, timestamp, " \
		"latitude, longitude, altitude, cameraMake, cameraModel, clientWillIndex, fileName, attachment)" \
		"values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"

#define INSERT_RESOURCE "insert into resources (guid, noteGuid, mime, width, height, duration, active, updateSequenceNum)" \
	"values (?, ?, ?, ?, ?, ?, ?, ?)"

#endif /* QVERNOTESTORAGEQUERIES_H_ */
