/* This file is part of the KDE libraries
   Copyright (C) 2001, 2002, 2007 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "limitediodevice_p.h"
#include <QtCore/QDebug>

using namespace Quasar;

LimitedIODevice::LimitedIODevice( QIODevice *dev, qint64 start, qint64 length )
    : m_dev( dev ), m_start( start ), m_length( length )
{
    //qDebug() << "start=" << start << "length=" << length;
    open( QIODevice::ReadOnly ); //krazy:exclude=syscalls
}

bool LimitedIODevice::open( QIODevice::OpenMode m )
{
    //qDebug() << "m=" << m;
    if ( m & QIODevice::ReadOnly ) {
        /*bool ok = false;
          if ( m_dev->isOpen() )
          ok = ( m_dev->mode() == QIODevice::ReadOnly );
          else
          ok = m_dev->open( m );
          if ( ok )*/
        m_dev->seek( m_start ); // No concurrent access !
    }
    else
        qWarning() << "LimitedIODevice::open only supports QIODevice::ReadOnly!";
    setOpenMode( QIODevice::ReadOnly );
    return true;
}

void LimitedIODevice::close()
{
}

qint64 LimitedIODevice::size() const
{
    return m_length;
}

qint64 LimitedIODevice::readData( char * data, qint64 maxlen )
{
    maxlen = qMin( maxlen, m_length - pos() ); // Apply upper limit
    return m_dev->read( data, maxlen );
}

bool LimitedIODevice::seek( qint64 pos )
{
    Q_ASSERT( pos <= m_length );
    pos = qMin( pos, m_length ); // Apply upper limit
    bool ret = m_dev->seek( m_start + pos );
    if ( ret ) {
        QIODevice::seek( pos );
    }
    return ret;
}

qint64 LimitedIODevice::bytesAvailable() const
{
     return m_length + QIODevice::bytesAvailable();
}

bool LimitedIODevice::isSequential() const
{
    return m_dev->isSequential();
}
