#include "webkitchatviewwidget.h"
#include "chatstyleoutput.h"
#include <QKeyEvent>
#include <QWebView>
#include <QWebFrame>
#include <QVBoxLayout>

namespace Core
{
    namespace AdiumChat
    {

	WebkitChatViewWidget::WebkitChatViewWidget() :
		QFrame(),
		ChatViewWidget(),
		m_view(new QWebView)
	{
	    new QVBoxLayout(this);
	    layout()->addWidget(m_view);
	    layout()->setMargin(0);
	    m_view->installEventFilter(this);
	    setFrameStyle(QFrame::StyledPanel);
	    setFrameShadow(QFrame::Sunken);
	}

	void WebkitChatViewWidget::setViewController(QObject *controller)
	{
	    //save scrollbar state
	    if(m_view->page()) {
		QWebFrame *frame = m_view->page()->mainFrame();
		frame->setProperty("scrollbarPos",frame->scrollBarValue(Qt::Vertical));
	    }
	    ChatStyleOutput *new_page = qobject_cast<ChatStyleOutput*>(controller);
	    if(new_page) {
		m_view->page()->setView(0);
		m_view->setPage(new_page);
		QTimer::singleShot(0,this,SLOT(scrollBarWorkaround()));
	    }
	}

	bool WebkitChatViewWidget::event(QEvent *event)
	{
	    return QFrame::event(event);
	}

	bool WebkitChatViewWidget::eventFilter(QObject *obj, QEvent *event)
	{
	    switch (event->type()) {
	    case QEvent::MouseButtonPress:
		if (static_cast<QMouseEvent *>(event)->button() == Qt::LeftButton)
		    mousePressed = true;
		break;
	    case QEvent::MouseButtonRelease:
		if (static_cast<QMouseEvent *>(event)->button() == Qt::LeftButton)
		    mousePressed = false;
		break;
	    case QEvent::MouseMove:
		if (mousePressed)
		    return true;
		break;
	    default:
		break;
	    }

	    if(obj->metaObject() == &QWebView::staticMetaObject) {
		if (event->type() == QEvent::KeyPress) {
		    QKeyEvent *keyEvent = static_cast<QKeyEvent *>(event);
		    if (keyEvent->matches(QKeySequence::Copy)) {
			m_view->triggerPageAction(QWebPage::Copy);
			return true;
		    }
		}
	    }
	    return QFrame::eventFilter(obj,event);
	}

	void WebkitChatViewWidget::scrollBarWorkaround()
	{
	    QWebFrame *frame = m_view->page()->mainFrame();
	    frame->setScrollPosition(QPoint(0,frame->scrollBarMaximum(Qt::Vertical)));
	}

    }
}
