import QtQuick 1.1

Item {
    signal clicked
    property alias text: txt.text
    property alias fontsize: txt.font.pixelSize
    property alias source: image.source
    id: main
    width: parent.width - 10
    height: 68
    anchors.horizontalCenter: parent.horizontalCenter

    Rectangle {
        id: border
        color: "#01262c"
        border.color:  "#59686a"
        border.width: 2
        smooth: true
        radius: 4
        //opacity: 0.6
        width: parent.width - 4
        height: parent.height - 4
        anchors.horizontalCenter: parent.horizontalCenter
        Behavior on scale {NumberAnimation{duration: 50; easing.type: Easing.InOutQuad}}

        Image {
            z: 10
            id: image
            anchors.fill: parent
        }
    }


    Text {
        id: txt
        anchors.centerIn: border
        color: "white"
        font.weight: Font.Light
    }
    MouseArea {
        id: mArea
        anchors.fill: parent
        onClicked: main.clicked()
    }
    states: State {
        name: "pressed"
        when: mArea.pressed
        PropertyChanges {
            target: border
            scale: 0.9
        }
    }

}

