import QtQuick 1.1

Column {
    id: column
    Button {
        text: "flash"
        fontsize: 17
        onClicked: {
            hideTimer.stop()
            mainW._findFlash()
           // Process.start("xterm")
        }
    }

    Button {
        text: "bookmarks"
        fontsize: 16
        onClicked: {
            mainW._bookmarks()
            mainW.hide()
            hideTimer.stop()
        }
    }
    Button {
        text: "bar"
        fontsize: 17
        onClicked: {
            mainW._addressBar()
            mainW.hide()
            hideTimer.stop()
        }
    }
    Button {
        text: "reload"
        fontsize: 17
        onClicked: {
            mainW._reload()
            mainW.hide()
            hideTimer.stop()
        }
    }
    Button {
        text: "back"
        fontsize: 17
        onClicked: {
            mainW._back()
            mainW.hide()
            hideTimer.stop()
        }
    }
    Button {
        text: "close"
        fontsize: 17
        onClicked: {
            mainW._closeWindow()
        }
    }
//        Button {
//            text: "task"
//            fontsize: 17
//            onClicked: {
//                mainW._showTaskMenu()
//                mainW.hide()
//                hideTimer.stop()
//            }
//        }
    Button {
        text: "previous"
        fontsize: 17
        onClicked: {
            mainW._previousWindow()
            mainW.hide()
            hideTimer.stop()
        }
    }
    Timer {
        id: hideTimer
        running: true
        interval: 2000
        onTriggered: {
            mainW.hide()
        }
    }
    Connections {
        target: mainW
        onEdgeSignal: {
            if(window == "browser")
            {
                mainW._show()
            }
        }
        onMenuShowEvent: {
            hideTimer.start()
        }
    }
}

