#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QDeclarativeView>
#include <QtGui>
#include <QDBusConnection>
#include <QDBusMessage>
#include <QDBusPendingCall>
#include <QDBusInterface>
#include <QDeclarativeContext>
#include <QDeclarativeEngine>
#include <QX11Info>
#include <QVariantMap>
#include "X11/Xlib.h"
#include "X11/extensions/XTest.h"

class MainWindow : public QDeclarativeView
{
    Q_OBJECT
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    
    bool isPortrait;

    static bool myEventFilter(void *message, long int *);

    static const MainWindow* instance();
    static MainWindow *mw;

public slots:
    void _back();
    void _reload();
    void _addressBar();
    void _closeWindow();
    void _bookmarks();
    void _move(int x, int y) {
        this->move(x, y);
    }
    void _showTaskMenu();
    void _previousWindow();
    void _show();
    void _findFlash();
    void _playFlash(QString vpath, QString playerPath);

    void _showEvent();

private slots:
    void onEdgeSignal(QStringList msg) {
        emit edgeSignal(msg.at(0), msg.at(1));
    }
    void onOrientationChanged();

signals:
    void edgeSignal(QString edge, QString window);
    void showVideos();
    void videoFound(QVariantMap item);
    void menuShowEvent();
};

#endif // MAINWINDOW_H
