#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cPickle
import os

HOME = os.getenv('HOME')

class History:
   def __init__(self):
      try:
         data = open(HOME + '/.quickclip/history.data', 'r')
         self.history = cPickle.load(data)
         self.history_target = cPickle.load(data)
         data.close()
      except Exception:
         self.history = []
         self.history_target = []

   def load(self):
      return (self.history, self.history_target)

   def clear(self, widget):
      self.history = []
      self.history_target = []
      self.write()

   def update(self, item, target_item):
      if len(item) > 50:
         item = item[0:50]
         item = item + "..."
      item = item.replace('\n', ' ')
      self.history_target.insert(0, target_item)
      self.history.insert(0, item)
      if len(self.history_target) > 10:
         del self.history[-1]
      if len(self.history) > 10:
         del self.history[-1]
      self.write()

   def write(self):
      data = open(HOME + '/.quickclip/history.data', 'w')
      cPickle.dump(self.history, data)
      cPickle.dump(self.history_target, data)
      data.close()