#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from target_files import *
import gtk
import hildonhelp
import osso

osso_context = osso.Context('com.quickclip.Quickclip','.5', False)

class Manage_Files:
   def __init__(self):
      self.target_files = Target_Files()

   def manage_files(self, widget, data=None):
      files_dialog = gtk.Dialog("Manage Your Target Files",None,gtk.DIALOG_MODAL)
      ok_button = files_dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = files_dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      new_file_button = gtk.Button("New")
      delete_file_button = gtk.Button("Delete")
      rename_button = gtk.Button("Rename")
      up_button = gtk.Button()
      up_button.set_image(gtk.image_new_from_file("/usr/share/icons/hicolor/26x26/hildon/qgn_indi_arrow_up.png"))
      down_button = gtk.Button()
      down_button.set_image(gtk.image_new_from_file("/usr/share/icons/hicolor/26x26/hildon/qgn_indi_arrow_down.png"))

      new_file_button.set_size_request(150, 50)
      delete_file_button.set_size_request(150, 50)
      rename_button.set_size_request(150, 50)
      up_button.set_size_request(150, 50)
      down_button.set_size_request(150, 50)

      hbox = gtk.HBox()
      main_vbox = gtk.VBox()
      list_vbox = gtk.VBox()

      main_vbox.pack_start(new_file_button, True, 5, 5)
      main_vbox.pack_start(delete_file_button, True, 5, 5)
      main_vbox.pack_start(rename_button, True, 5, 5)
      main_vbox.pack_start(up_button, True, 5, 5)
      main_vbox.pack_start(down_button, True, 5, 5)

      self.liststore = gtk.ListStore(str)

      for item in self.target_files.get_files():
         self.liststore.append([item])

      self.treeview = gtk.TreeView(self.liststore)
      self.treeview.set_reorderable(True)
      tvcolumn = gtk.TreeViewColumn('Column 0')
      self.treeview.append_column(tvcolumn)
      cell = gtk.CellRendererText()
      tvcolumn.pack_start(cell, True)
      tvcolumn.add_attribute(cell, 'text', 0)

      scrolled_window = gtk.ScrolledWindow()
      scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      scrolled_window.set_size_request(400, -1)
      scrolled_window.add(self.treeview)

      list_vbox.pack_start(scrolled_window, True, 5, 5)

      hbox.pack_start(list_vbox, True, 5, 5)
      hbox.pack_end(main_vbox, True, 5, 5)

      files_dialog.vbox.pack_start(hbox)

      ok_button.connect('clicked', self.ok_callback)
      new_file_button.connect('clicked', self.new_file_dialog)
      delete_file_button.connect('clicked', self.delete_file_callback)
      rename_button.connect('clicked', self.rename_callback)
      up_button.connect('clicked', self.up_callback)
      down_button.connect('clicked', self.down_callback)

      hildonhelp.help_dialog_help_enable(files_dialog, "osso_quickclip_manage", osso_context)

      files_dialog.show_all()
      files_dialog.run()     
      files_dialog.destroy()

   def ok_callback(self, widget):
      files_list = self.treeview.get_model()

      files = []

      for item in files_list:
         files.append(item[0])             
      self.target_files.set_files(files)

   def new_file_dialog(self, widget):

      dialog = gtk.Dialog("Enter New Name",None,gtk.DIALOG_MODAL)
      dialog.set_size_request(300, -1)
      ok_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      entry = gtk.Entry(20)
      ok_button.connect('clicked', self.new_file_entry_callback, entry)
      dialog.vbox.pack_start(entry, True, 10, 10)

      dialog.show_all()
      dialog.run()     
      dialog.destroy()

   def new_file_entry_callback(self, widget, entry):
      text = entry.get_text()
      if text == "":
         return
      self.liststore.append([text])

   def delete_file_callback(self, widget):
      selection = self.treeview.get_selection()
      model, treeiter = selection.get_selected()
      if treeiter is not None:
         model.remove(treeiter)

   def rename_callback(self, widget):

      dialog = gtk.Dialog("Enter New Name",None,gtk.DIALOG_MODAL)
      dialog.set_size_request(300, -1)
      ok_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      self.entry = gtk.Entry(20)
      ok_button.connect('clicked', self.rename_file_entry_callback)
      dialog.vbox.pack_start(self.entry, True, 10, 10)

      dialog.show_all()
      dialog.run()     
      dialog.destroy()

   def rename_file_entry_callback(self, widget):
      text = self.entry.get_text()
      if text == "":
         return

      selection = self.treeview.get_selection()
      model, treeiter = selection.get_selected()
      self.liststore.set(treeiter, 0 , text)

   def up_callback(self, widget):
      selection = self.treeview.get_selection()
      model, treeiter = selection.get_selected()
      path = self.liststore.get_path(treeiter)
      a_row = path[0]
      b_row = a_row - 1
      a = treeiter
      b = self.liststore.get_iter(b_row)
      self.liststore.swap(a, b)

   def down_callback(self, widget):
      selection = self.treeview.get_selection()
      model, treeiter = selection.get_selected()
      path = self.liststore.get_path(treeiter)
      a_row = path[0]
      b_row = a_row + 1
      a = treeiter
      b = self.liststore.get_iter(b_row)
      self.liststore.swap(a, b)
