#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk
import hildonhelp
import osso
from clip_tools import *

a_name = "Quick Clip"
a_version = "0.4.5"
osso_context = osso.Context('com.quickclip.Quickclip','.4.5', False)

class Dialogs:

   def about_dialog(self,widget,data=None):
      about_quick_clip = gtk.AboutDialog()
      about_quick_clip.set_name(a_name)
      about_quick_clip.set_version(a_version)
      about_quick_clip.set_logo(gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/40x40/hildon/quick_clip-40x40.png"))
      about_quick_clip.set_comments("""
The fast and easy way to copy and save information.
""")
      about_quick_clip.set_copyright("Copyright 2009, Brent Chiodo")
      about_quick_clip.set_license("""This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program.  If not, see
<http://www.gnu.org/licenses/>.""")

      authors = ["Brent Chiodo <bchiodo@gmail.com>", "","Thanks To:", "Faheem Pervez (qwerty12)", "Thomas Perl (thp)"]
      about_quick_clip.set_authors(authors)
      about_quick_clip.run()
      about_quick_clip.destroy()

# Donations

   def donations(self, widget, data=None):
      dialog = gtk.Dialog("Donate to Quick Clip",None,gtk.DIALOG_MODAL)
      dialog.set_size_request(700, 375)
      close_button = dialog.add_button(gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE)
      donate_button = dialog.add_button("Donate", 1)

      sw = gtk.ScrolledWindow()
      sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      textview = gtk.TextView()
      textview.set_sensitive(False)
      textbuffer = textview.get_buffer()
      textview.set_wrap_mode(gtk.WRAP_WORD)
      textbuffer.set_text("""Quick Clip is completely free to use, modify, distribute, and enjoy. But if you like using Quick Clip, please consider making a donation. Donations not only help to offset the cost of development, but can possibly guilt me in to fixing bugs or adding new features.

If you would like to help support Quick Clip, just click the "Donate" button below (donations can be any amount of your choosing).

Thank you,
Brent Chiodo""")
      sw.add(textview)

      dialog.vbox.pack_start(sw)

      sw.show()
      textview.show()

      response = dialog.run()

      if response == 1:
         subprocess.Popen('/usr/bin/dbus-send --print-reply --dest=com.nokia.osso_browser /com/nokia/osso_browser com.nokia.osso_browser.mime_open string:"file:///home/user/.quickclip/donate.html"', shell=True)

      dialog.destroy()

# Main Help

   def help(self, widget, data=None):
      hildonhelp.help_show(osso_context, "osso_quickclip_intro", 0)

# The Entry >> File dialog

   def entry_dialog(self, widget, name, menu):
      entry_dialog = gtk.Dialog("Enter Text Here",None,gtk.DIALOG_MODAL)
      entry_dialog.set_size_request(600, 300)
      ok_button = entry_dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = entry_dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      sw = gtk.ScrolledWindow()
      sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      textview = gtk.TextView()
      textview.set_wrap_mode(gtk.WRAP_WORD)
      textbuffer = textview.get_buffer()
      sw.add(textview)
      sw.show()
      textview.show()

      ok_button.connect("clicked", self.entry_dialog_callback, name, textbuffer, menu)

      entry_dialog.vbox.pack_start(sw)

      entry_dialog.show_all()
      entry_dialog.run()     
      entry_dialog.destroy()

# Function to get text from the textbuffer

   def entry_dialog_callback(self, widget, name, textbuffer, menu):

      text = textbuffer.get_text(*textbuffer.get_bounds())

      if text == "":
         return

      Clip_Tools().clip_entry(name, text, menu)