#!/usr/bin/env python

from distutils.core import setup
import os

HOME = os.getenv('HOME')

setup(name='quickclip',
   version='0.4.4',
   scripts=['quickclip_viewer.py'],
   data_files = [
      ('/etc/osso-backup/applications/',['quickclip.conf']),
      ('/usr/share/applications/hildon-status-bar/',['quickclip.desktop']),
      ('/usr/lib/hildon-desktop/',['statusbar/quickclip.py']),
      ('/usr/share/icons/hicolor/26x26/hildon/',['quick_clip-26x26.png', 'qcv-26/qcv.png']),
      ('/usr/share/icons/hicolor/40x40/hildon/',['quick_clip-40x40.png', 'qcv-40/qcv.png']),
      ('/usr/share/osso-help/en_US/',['quickclip.xml']),
      ('/usr/share/osso-help/graphics/',['quickclip.png', 'quickclip_up.png', 'quickclip_down.png']),
      ('/usr/share/icons/hicolor/scalable/hildon/',['qcv-scalable/qcv.png']),
      ('/usr/share/applications/hildon/', ['qcv.desktop']),
      (HOME + '/.quickclip/', ['donate.html', 'donate.css', 'statusbar/quickclip.conf', 'viewer.conf']),
      ('/usr/lib/quickclip/', ['statusbar/clip_tools.py', 'statusbar/dialogs.py', 'statusbar/history.py', 'statusbar/main_menu.py', 'statusbar/manage_files.py', 'statusbar/settings_dialog.py', 'statusbar/settings.py', 'statusbar/target_files.py'])
      ]
      )