import Qt 4.7
//import quickwidgets 1.0

Rectangle {
     id: proclabel
     width: 100
     height: childrenRect.height
     color: "blue"
     opacity: 0.8
     radius: 5

     function parse(stdout) {
         var rx = /[0-9]+/gi;
         var val = stdout.match(rx)
         return String(val)
     }

     property string command: "sh -c \"cat /proc/meminfo | /bin/grep 'Active:'\""
     property string label: "Value:"
     property string textcolor: "white"
     property real interval_in_sec: 5

     function setText() {
         txt.text = txt.stagedtxt
     }

     Text {
          property string stagedtxt: ""
     	  id: txt
	  smooth: true
          font.pointSize: 16
          anchors.right: proclabel.right
          anchors.margins: 5
          text: ""
	  verticalAlignment: Text.AlignVCenter
          horizontalAlignment: Text.AlignRight
          color: proclabel.textcolor
          Behavior on stagedtxt {
              SequentialAnimation {
                  NumberAnimation { target: txt; property: "opacity"; to: 0; duration: 300 }
                  ScriptAction { script: setText(); }
                  NumberAnimation { target: txt; property: "opacity"; to: 1; duration: 500 }
              }
          }
      }

     Text {
          id: label
          smooth: true
          font.pointSize: 16
          font.weight: Font.Bold
          anchors.left: proclabel.left
          anchors.margins: 5
          text: proclabel.label
          verticalAlignment: Text.AlignVCenter
          horizontalAlignment: Text.AlignLeft
          color: proclabel.textcolor
     }

     Process {
     	  id: process
          command: proclabel.command
          onCompleted: { txt.stagedtxt = parse(stdout);}
          onFailed: { proclabel.color = "red"; txt.stagedtxt = stderr }
     }

     Timer {
         id: timer
          triggeredOnStart: true
     	  running: runtime.isActiveWindow
          repeat: true
          interval: proclabel.interval_in_sec*1000
          onTriggered: { process.run() }
     }
 }
