import Qt 4.7
import QtWebKit 1.0

Rectangle {
    width: 800
    height: 480
    color: "white"

    Item {
	    id: urlItem
	    property string book
	    property string chapter
	    property string url: "http://scriptures.lds.org/en/" + book + "/" + chapter
	    visible: false
	    anchors.fill: parent
	    function go() {
		    webView.url = url;
	    }

	    Flickable {
		    id: flickable
		    contentWidth: Math.max(parent.width,webView.width)
		    contentHeight: Math.max(parent.height,webView.height)
		    anchors.fill: parent
		    WebView {
			    id: webView
			    preferredWidth: flickable.width
			    preferredHeight: flickable.height

		    }
	    }
	    onUrlChanged: {
		    console.log("new url: " + url)
	    }

    }

    ListModel {
	    id: superbookmodel
	    ListElement { book: "Old Testament"; submodel: "ot"}
	    ListElement { book: "New Testament"; submodel: "nt"}
	    ListElement { book: "Book of Mormon"; submodel: "bom"}
	    ListElement { book: "Doctrine and Covenants"; submodel: "dnc"}
	    ListElement { book: "Pearl of Great Price"; submodel: "pgp"}

    }

    ListModel {
	    id: oldtestamentmodel

	    ListElement { book: "Genesis"; cdata: "gen"; chapters: 50}
	    ListElement { book: "Exodes"; cdata: "ex"; chapters: 40}
	    ListElement { book: "Leviticus"; cdata: "lev"; chapters: 27}
	    ListElement { book: "Numbers"; cdata: "num"; chapters: 36}
	    ListElement { book: "Deuteronomy"; cdata: "deut"; chapters: 34}
	    ListElement { book: "Joshua"; cdata: "josh"; chapters: 24}
	    ListElement { book: "Judges"; cdata: "judg"; chapters: 21}
	    ListElement { book: "Ruth"; cdata: "ruth"; chapters: 4}
	    ListElement { book: "1 Samuel"; cdata: "1_sam"; chapters: 31}
	    ListElement { book: "2 Samuel"; cdata: "2_sam"; chapters: 24}
	    ListElement { book: "1 Kings"; cdata: "1_kgs"; chapters: 28}
	    ListElement { book: "2 Kings"; cdata: "2_kgs"; chapters: 25}
	    ListElement { book: "1 Chronicals"; cdata: "1_chr"; chapters: 29}
	    ListElement { book: "2 Chronicals"; cdata: "2_chr"; chapters: 36}
	    ListElement { book: "Ezra"; cdata: "ezra"; chapters: 10}
	    ListElement { book: "Nehemiah"; cdata: "neh"; chapters: 13}
	    ListElement { book: "Esther"; cdata: "esth"; chapters: 10}
	    ListElement { book: "Job"; cdata: "job"; chapters: 42}
	    ListElement { book: "Psalms"; cdata: "ps"; chapters: 150}
	    ListElement { book: "The Proverbs"; cdata: "prov"; chapters: 31}
	    ListElement { book: "Ecclesiastes"; cdata: "eccl"; chapters: 12}
	    ListElement { book: "The Song of Solomon"; cdata: "song"; chapters: 8}
	    ListElement { book: "Isaiah"; cdata: "isa"; chapters: 66}
	    ListElement { book: "Jermiah"; cdata: "jer"; chapters: 52}
	    ListElement { book: "Lamentations"; cdata: "lam"; chapters: 5}
	    ListElement { book: "Ezekiel"; cdata: "ezek"; chapters: 48}
	    ListElement { book: "Daniel"; cdata: "dan"; chapters: 12}
	    ListElement { book: "Hosea"; cdata: "hosea"; chapters: 14}
	    ListElement { book: "Joel"; cdata: "joel"; chapters: 3}
	    ListElement { book: "Amos"; cdata: "amos"; chapters: 9}
	    ListElement { book: "Obadiah"; cdata: "obad"; chapters: 1}
	    ListElement { book: "Jonah"; cdata: "jonah"; chapters: 4}
	    ListElement { book: "Micah"; cdata: "micah"; chapters: 7}
	    ListElement { book: "Nahum"; cdata: "nahum"; chapters: 3}
	    ListElement { book: "Habakkuk"; cdata: "hab"; chapters: 3}
	    ListElement { book: "Zephaniah"; cdata: "zeph"; chapters: 3}
	    ListElement { book: "Haggai"; cdata: "hag"; chapters: 2}
	    ListElement { book: "Zechariah"; cdata: "zech"; chapters: 14}
	    ListElement { book: "Malachi"; cdata: "mal"; chapters: 4}
    }

    ListModel {
	    id: newtestamentmodel

	    ListElement { book: "Matthew"; cdata: "matt"; chapters: 28}
	    ListElement { book: "Mark"; cdata: "mark"; chapters: 16}
	    ListElement { book: "Luke"; cdata: "luke"; chapters: 24}
	    ListElement { book: "John"; cdata: "john"; chapters: 21}
	    ListElement { book: "The Acts"; cdata: "acts"; chapters: 28}
	    ListElement { book: "The Epistle to the Romans"; cdata: "rom"; chapters: 16}
	    ListElement { book: "1 Corinthians"; cdata: "1_cor"; chapters: 16}
	    ListElement { book: "2 Corinthians"; cdata: "2_cor"; chapters: 13}
	    ListElement { book: "Galatians"; cdata: "gal"; chapters: 6}
	    ListElement { book: "Ephesians"; cdata: "eph"; chapters: 6}
	    ListElement { book: "Philippians"; cdata: "philip"; chapters: 4}
	    ListElement { book: "Colossians"; cdata: "col"; chapters: 4}
	    ListElement { book: "1 Thessalonians"; cdata: "1_thes"; chapters: 5}
	    ListElement { book: "2 Thessalonians"; cdata: "2_thes"; chapters: 22}
	    ListElement { book: "1 Timothy"; cdata: "1_tim"; chapters: 6}
	    ListElement { book: "2 Timothy"; cdata: "2_tim"; chapters: 4}
	    ListElement { book: "Titus"; cdata: "titus"; chapters: 3}
	    ListElement { book: "Philemon"; cdata: "philem"; chapters: 1}
	    ListElement { book: "To the Hebrews"; cdata: "heb"; chapters: 13}
	    ListElement { book: "The Epistle of James"; cdata: "james"; chapters: 5}
	    ListElement { book: "1 Peter"; cdata: "1_pet"; chapters: 5}
	    ListElement { book: "2 Peter"; cdata: "2_pet"; chapters: 3}
	    ListElement { book: "1 John"; cdata: "1_jn"; chapters: 5}
	    ListElement { book: "2 John"; cdata: "2_jn"; chapters: 1}
	    ListElement { book: "3 John"; cdata: "3_jn"; chapters: 1}
	    ListElement { book: "Jude"; cdata: "jude"; chapters: 1}
	    ListElement { book: "Revelation"; cdata: "rev"; chapters: 22}

    }

    ListModel {
	    id: bookofmormonmodel

	    ListElement { book: "1 Nephi"; cdata: "1_ne"; chapters: 22}
	    ListElement { book: "2 Nephi"; cdata: "2_ne"; chapters: 33}
	    ListElement { book: "Jacob"; cdata: "jacob"; chapters: 7}
	    ListElement { book: "Enos"; cdata: "enos"; chapters: 1}
	    ListElement { book: "Jarom"; cdata: "jarom"; chapters: 1}
	    ListElement { book: "Omni"; cdata: "omni"; chapters: 1}
	    ListElement { book: "Words of Mormon"; cdata: "w_of_m"; chapters: 1}
	    ListElement { book: "Mosiah"; cdata: "mosiah"; chapters: 29}
	    ListElement { book: "Alma"; cdata: "alma"; chapters: 63}
	    ListElement { book: "Helaman"; cdata: "helaman"; chapters: 16}
	    ListElement { book: "3 Nephi"; cdata: "3_ne"; chapters: 30}
	    ListElement { book: "4 Nephi"; cdata: "4_ne"; chapters: 1}
	    ListElement { book: "Mormon"; cdata: "morm"; chapters: 9}
	    ListElement { book: "Ether"; cdata: "ether"; chapters: 15}
	    ListElement { book: "Moroni"; cdata: "moro"; chapters: 10}
    }

    ListModel {
	    id: pearlmodel

	     ListElement { book: "Book of Moses"; cdata: "moses"; chapters: 8}
	     ListElement { book: "Book of Abraham"; cdata: "abr"; chapters: 5}
	     ListElement { book: "Joseph Smith Matthew"; cdata: "js_m"; chapters: 1}
	     ListElement { book: "Joseph Smith History"; cdata: "js_h"; chapters: 1}
	     ListElement { book: "Articles of Faith"; cdata: "a_of_f"; chapters: 1}
    }

    ListModel {
	    id: dandcmodel
	    ListElement { booK: "Doctrine and Covenants"; cdata: "dc"; chapters: 138 }
    }

    ListView {
	    id: superbookview
	    model: superbookmodel
	    anchors.fill: parent
	    spacing: 5
	    delegate: Item {
			    id: thingy

			    width: parent.width
			    height: 60
			    Rectangle{
				    radius: 5
				    anchors.fill: parent
				    opacity: 0.5
				    color: "lightblue"
			    }
			    Text {
				    anchors.centerIn: thingy
				    text: book
				    font.pointSize: 24;
			    }

			    MouseArea {
				    anchors.fill: parent
				    onClicked: {
					    if (submodel == "ot")
						    booklistView.model = oldtestamentmodel
					    else if (submodel == "nt")
						    booklistView.model = newtestamentmodel
					    else if(submodel == "bom")
						    booklistView.model = bookofmormonmodel
					    else if(submodel == "dnc")
						    booklistView.model = dandcmodel
					    else if(submodel == "pgp")
						    booklistView.model = pearlmodel
					    booklistView.visible = true
					    superbookview.visible = false
				    }
			    }
		    }
    }

    ListView {
	    id: booklistView
	    anchors.fill: parent
	    model: pearlmodel
	    spacing: 5
	    visible: false
	    delegate: Item {
			    id: thingy

			    width: parent.width
			    height: 60
			    Rectangle{
				    radius: 5
				    anchors.fill: parent
				    opacity: 0.5
				    color: "lightblue"
			    }
			    Text {
				    anchors.centerIn: thingy
				    text: book
				    font.pointSize: 24;
			    }

			    MouseArea {
				    anchors.fill: parent
				    onClicked: {
					    urlItem.book = cdata
					    booktext.text = book
					    chaptertext.text = ""
					    if(chapters != 1) {
						    chapterlistView.model = chapters
						    chapterlistView.visible = true
						    booklistView.visible = false
					    }
					    else {
						    urlItem.chapter=1;
						    urlItem.go()
						    chapterlistView.visible = false
						    booklistView.visible = false
						    urlItem.visible=true

					    }

				    }
			    }
		    }
	    onModelChanged: {
		    if(model.length == 1) {
			    chapterlistView.model = model.get(0).chapters
			    chapterlistView.visible = true
			    booklistView.visible = false
		    }
	    }
    }

    ListView {
	    id: chapterlistView
	    anchors.fill: parent
	    visible: false
	    spacing: 5
	    delegate: Item {
			    id: thingy

			    width: parent.width
			    height: 60
			    Rectangle{
				    radius: 5
				    anchors.fill: parent
				    opacity: 0.5
				    color: "lightblue"
			    }
			    Text {
				    anchors.centerIn: thingy
				    text: modelData + 1
				    font.pointSize: 24;
			    }

			    MouseArea {
				    anchors.fill: parent
				    onClicked: {
					    chaptertext.text = modelData + 1
					    urlItem.chapter = modelData + 1
					    urlItem.visible = true
					    urlItem.go();
					    chapterlistView.visible = false;
				    }
			    }
		    }
    }


    Item {
	    id: toolbar
	    anchors.bottom: parent.bottom
	    height: startoverbutton.height
	    width: parent.width
	    visible: !superbookview.visible

	    Rectangle {
		    anchors.fill: parent
		    color: "grey"
		    opacity: 0.5
	    }

	    Image {
		    anchors.verticalCenter: parent.verticalCenter
		    anchors.left: parent.left
		    anchors.leftMargin: 10
		    id: startoverbutton
		    source: "home.png"

		    MouseArea {
			    anchors.fill: parent

			    onClicked: {
				    urlItem.visible = false;
				    chapterlistView.visible = false
				    booklistView.visible = false
				    superbookview.visible = true
			    }
		    }
	    }

	    Text {
		    id: booktext
		    anchors.verticalCenter: parent.verticalCenter
		    anchors.left: startoverbutton.right
		    anchors.leftMargin: 10
		    font.pointSize: 20
		    text: ""
	    }

	    Text {
		    id: chaptertext
		    anchors.verticalCenter: parent.verticalCenter
		    anchors.left: booktext.right
		    anchors.leftMargin: 10
		    font.pointSize: 20
		    text: ""
	    }

	    Text {
		    id: loadPercentage
		    anchors.verticalCenter: parent.verticalCenter
		    anchors.left: chaptertext.right
		    anchors.leftMargin: 10
		    text: (webView.progress * 100) + "%"
		    font.pointSize: 20
		    visible: webView.visible
	    }

	    Image {
		    anchors.verticalCenter: parent.verticalCenter
		    anchors.right: parent.right
		    anchors.rightMargin: 10
		    id: browserBack
		    source: "back.png"
		    visible: urlItem.visible
		    MouseArea {
			    anchors.fill: parent

			    onClicked: {
				    webView.back.trigger();
			    }
		    }
	    }
    }

}

