/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef LISTOFCARDS_H
#define LISTOFCARDS_H


#include <QtGui>
#include <QDebug>

#include "DatabaseManager.h"
#include "DetailedWindow.h"
#include "OptionsDialog.h"
#include "AntiTheftOptionsDialog.h"
#include "RenameGroupDialog.h"
#include "DetailedWindow.h"
#include "LoginDialog.h"
#include "EditTemplates.h"


class MyLoadImageThread: public QThread {
	Q_OBJECT

	signals:
		void loadImageFor (int index);
	public:
		int size;

		void run() {
			qDebug () << "loading images START";
			for (int i = 0; i < size; i++) {
				qDebug () << "loading image " << i;
				emit loadImageFor(i);
			}
			qDebug () << "loading images FINISH";
		}
};

class ListOfCards: public QWidget
{
	Q_OBJECT

public:

	ListOfCards (bool isF, QWidget * parent = 0);
	ListOfCards (bool isF, QString * group, QWidget *parent = 0);
	~ListOfCards ();

	void showInfo(int isShowGroups, bool reset);
	void reloadInfo ();

	void reloadGroups ();

	bool _deleteTarget(Target* target);
	bool _updateTarget(Target* target);
	bool _updateTargetPicture(Target* target);
	bool _insertTarget(Target* target);
	
	int currentRow ();
	QString getGroup (int i);

signals:
	void selectGroup (QString * name);
	void selectTarget (Target * target);

	void renameGroup(QString n);
	void deleteGroup(QString n);
	void viewTarget(Target * t);
	void editTarget(Target * t);
	void newLikeTarget(Target * t);
	void duplicateTarget(Target * t);
	void deleteTarget(Target * t);

public slots:
	void sort ();

	void _renameGroup();
	void _deleteGroup();
	void _viewTarget();
	void _editTarget();
	void _newLikeTarget();
	void _duplicateTarget();
	void _deleteTarget();

	void selectItem(QListWidgetItem *);
	void selectDItem(QListWidgetItem *);


private:
	class MyDelegate;

	QPointer<MyLoadImageThread> threadLoad;

	QAbstractItemDelegate * originalDelegate;
	QAbstractItemDelegate * newDelegate;

	void showList (bool interactive);
	void keyPressEvent(QKeyEvent*);
	void showTargets(bool reset, const QString * filter);
	void showGroups(bool reset);

	void filterBy (const QString & s);

private slots:
	void loadImageFor (int index);
	void _clickBack();
	void changeMode ();
	void _cancelSearch ();
	void _hideSearch ();
	void textChanged (const QString &);

	void contextMenuEvent (QContextMenuEvent * event);

private:
	QSettings settings;

//	void askPassword ();
//	void askAgainPassword ();
//	void closeEvent(QCloseEvent *event);
	bool isFirst;
	bool isUnLockMode;
	QVBoxLayout * vboxlayout;
	int times;
	QListWidget* fnListWidget;
	QList<Target *> list;
	QList<QString> grouplist;

	QHBoxLayout * inputWidget;
	QPushButton * cancelSearch;
	QPushButton * hideSearch;
	QLineEdit * searchField;
	//QPushButton * backButton;

	QPointer<DetailWindow> detailWindow;
	QPointer<DetailWindow> detailWindowEdit;
	QPointer<eWallet> extraWindow;
	QWidget* centralWidget;
	QPointer <QMessageBox> messageBox;
	bool opendb;
	bool initdb;
	bool ascSort;
	int isShowGroups;
	QString currentFilter;
	QString * currentGroup;

	QString tempPass;
};


#endif // LISTOFCARDS_H
