#include "MainUI.hpp"
#include "Options.hpp"

#include <QTabWidget>
#include <QBoxLayout>
#include <QLabel>

namespace testopt
{


using qtplus::SettingsModel;
using qtplus::OptionsGroup;

MainDialog::MainDialog()
		: tabs_(new QTabWidget(this))
		, model_(new SettingsModel(this))
{
	setWindowTitle("Test options");

	QLabel *lbl = new QLabel();
	tabs_->addTab(lbl, "Options");
	setCentralWidget(tabs_);
	model_->addGroup(SettingsModel::group_ptr(new OptionsGroup("Group1")));
}

} // namespace testopt
