/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QtCore/QCoreApplication>
//#include "server.h"
#include "TorrentSession.hpp"

using qtrapids::TorrentSession;
using qtrapids::settings_weak_ptr;

int main(int argc, char *argv[])
{
	QCoreApplication::setOrganizationName("Ixonos");
	QCoreApplication::setOrganizationDomain("ixonos.com");
	QCoreApplication::setApplicationName("QtRapids");
	QSettings settings(QCoreApplication::organizationName()
	                   , QCoreApplication::applicationName());

	QCoreApplication app(argc, argv);
	TorrentSession server(&app, &settings);
	QObject::connect(&server, SIGNAL(terminate()), &app, SLOT(quit()));
	return app.exec();
}
