/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "TorrentHandle.hpp"
#include <QDebug>


namespace qtrapids
{

TorrentHandle::TorrentHandle(libtorrent::torrent_handle handle) :
		torrentHandle_(handle)
{
}


TorrentHandle::~TorrentHandle()
{
}


TorrentStatus_t TorrentHandle::status() const
{
	return torrentHandle_.status();
}


torrent_info_cref TorrentHandle::getTorrentInfo() const
{
	return torrentHandle_.get_torrent_info();
}


bool TorrentHandle::isValid() const
{
	return torrentHandle_.is_valid();
}


QString TorrentHandle::name() const
{
	return QString::fromStdString(torrentHandle_.name());
}

size_t TorrentHandle::getTotalSize() const
{
	torrent_info_cref info = getTorrentInfo();
	return static_cast<size_t> (info.total_size());
}

size_t TorrentHandle::getTotalDone() const
{
	TorrentStatus_t statusTmp = status();
	return static_cast<size_t> (statusTmp.total_done);
}

TorrentStatus::Id TorrentHandle::state() const
{
	TorrentStatus::Id s = (TorrentStatus::Id)(status().state);
	return ( (s < TorrentStatus::UNSPECIFIED)
	         ? s : TorrentStatus::UNSPECIFIED );
}


float TorrentHandle::progress() const
{
	TorrentStatus_t statusTmp = status();
	return statusTmp.progress;
}

float TorrentHandle::uploadRate() const
{
	TorrentStatus_t statusTmp = status();
	return statusTmp.upload_rate;
}


float TorrentHandle::downloadRate() const
{
	TorrentStatus_t statusTmp = status();
	return statusTmp.download_rate;
}


qint32 TorrentHandle::numSeeds() const
{
	TorrentStatus_t statusTmp = status();
	return statusTmp.list_seeds;
}


qint32 TorrentHandle::numLeeches() const
{
	TorrentStatus_t statusTmp = status();
	return (statusTmp.list_peers - statusTmp.list_seeds);
}


qint32 TorrentHandle::ratio() const
{
	TorrentStatus_t statusTmp = status();
	size_t ratio;
	if (statusTmp.total_payload_download == 0) {
		ratio = 0;
	} else {
		ratio = static_cast<size_t> (statusTmp.total_payload_upload / statusTmp.total_payload_download);
	}

	return ratio;
}


torrent_handle_t TorrentHandle::getHandle() const
{
	return torrentHandle_;
}


bool TorrentHandle::operator==(TorrentHandle const& h) const
{
	return torrentHandle_ == h.torrentHandle_;
}


bool TorrentHandle::operator<(TorrentHandle const& h) const
{
	return torrentHandle_ < h.torrentHandle_;
}


}
