/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DOWNLOADMANAGER_H
#define DOWNLOADMANAGER_H


#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QUrl>
#include <QFile>


class DownloadManager : public QObject
{
	Q_OBJECT
	
	public:
		DownloadManager(QObject *parent = NULL);
		DownloadManager(QUrl url, QString outfile, QObject *parent = NULL);
		virtual ~DownloadManager();
		virtual void start();
		void setUrl(QUrl url);
		void setFilepath(QString filepath);
		
	public slots:
		void on_readyRead();
		void on_downloadProgress(qint64 bytesReceived, qint64 bytesTotal);
		void on_replyFinished();
		
	signals:
		void progress(int prog);
		void finished(QString filepath);
		
	private:
		bool WriteToFile();
		
	private:
		QNetworkAccessManager manager_;
		QUrl url_;
		QNetworkReply *reply_;
		QString filepath_;
		QFile file_;
};

#endif
