/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QTORRENTHANDLE_H
#define QTORRENTHANDLE_H

#include <QtGlobal>

#include <libtorrent/torrent_handle.hpp>


typedef libtorrent::torrent_status TorrentStatus;
typedef libtorrent::torrent_info TorrentInfo;
typedef libtorrent::torrent_handle TorrentHandle;


/**
	@author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/

namespace qtrapids
{

class QTorrentHandle
{
public:

	enum State {
		QUEUED_FOR_CHECKING = TorrentStatus::queued_for_checking,
		CHECKING_FILES,
		DOWNLOADING_METADATA,
		DOWNLOADING,
		FINISHED,
		SEEDING,
		ALLOCATING,
		UNSPECIFIED
	};

	QTorrentHandle(libtorrent::torrent_handle handle);
	~QTorrentHandle();



	TorrentInfo const& getTorrentInfo() const;

	bool isValid() const;

	QString name() const;
	size_t getTotalSize() const;
	QTorrentHandle::State state() const;
	float progress() const;
	float uploadRate() const;
	float downloadRate() const;
	qint32 numSeeds() const;
	qint32 numLeeches() const;
	qint32 ratio() const;

	TorrentHandle getHandle() const;

	bool operator==(QTorrentHandle const& h) const;
	bool operator<(QTorrentHandle const& h) const;

private:
	QTorrentHandle(); // Prevent default construct.
	TorrentHandle torrentHandle_;

	TorrentStatus status() const;

};

} // namespace qtrapids
#endif
