/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SEEDVIEW_H
#define SEEDVIEW_H

#include <QTreeWidget>

namespace qtrapids
{

class TorrentHandle;
class SeedViewItem;

/**
   @author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/
class SeedView : public QTreeWidget
{
	Q_OBJECT
public:
	SeedView(QWidget* parent);

	~SeedView();

private slots:
	void on_itemPressed(QTreeWidgetItem *item, int column);

private:

	// Name
	// Size
	// Status
	// UP speed
	// Seeds/Leechers
	// Connected peers
	// total uploaded
	// ratio
};

/**
   @class DownloadViewItem
   @brief Represents one item row of DownloadView
*/
class SeedViewItem : public QTreeWidgetItem
{

public:

	SeedViewItem(QTreeWidget* parent, int type) :
			QTreeWidgetItem(parent, type = QTreeWidgetItem::UserType) {};

	SeedViewItem(const QStringList& strings, int type = QTreeWidgetItem::UserType ) :
			QTreeWidgetItem (strings, type = Type) {};


	/// @return An item comprising of string list, suitable for QTableView
	/// header.
	static SeedViewItem *getHeaderItem() {
		SeedViewItem *item
		= new SeedViewItem(QStringList()
		                   << "Name"
		                   << "Size" << "Status"
		                   << "Progress" << "UL speed" << "Seeds/Leechers"
		                   << "Conn. peers"
		                   << "Ratio");

		return item;
	}

	/// @todo TorrentHandle as one hidden column
};

} // namespace qtrapids

#endif
