/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <QScrollArea>
#include <QGroupBox>
#include <QGridLayout>
#include <QTreeWidgetItem>
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QAbstractButton>

#ifdef Q_WS_MAEMO_5
	#include <QAbstractKineticScroller>
#endif

#include "ColumnSelectorDialog.h"


ColumnSelectorDialog::ColumnSelectorDialog(QTreeWidget *treewidget, QWidget* parent, Qt::WindowFlags f) :
	QDialog(parent, f), // Superclass construct
	dialogButtons_(NULL),
	grid_(NULL),
	treeWidget_(treewidget),
	scroller_(NULL),
	checkBoxes_()
{
	QScrollArea *scrollArea = new QScrollArea(this);

#ifdef Q_WS_MAEMO_5
	/// @todo Kineticscrolling (property "FingerScrollable" does not work in Qt 4.6, only in 4.5)	
	scroller_ = scrollArea->property("kineticScroller").value<QAbstractKineticScroller*>();

	if (!scroller_)                                                               
		qFatal("This example only works with QMaemo5Style as the default style for all QAbstractScrollAreas"); 
#endif

	scrollArea->setWidgetResizable(true);
	//scrollArea->setProperty("FingerScrollable", false);
	QBoxLayout *verticalBox = new QBoxLayout(QBoxLayout::TopToBottom);
	grid_ = new QGridLayout;
	QCheckBox *cbox = NULL;



	// Create scrollable checkbox dialog to allow proper viewing on Maemo:
	verticalBox->addWidget(scrollArea);
	// A "temporary" widget for containing QScrollArea stuff
	QWidget* scrollAreaWidgetContents = new QWidget(); 
	scrollAreaWidgetContents->setLayout(grid_);
	scrollArea->setWidget(scrollAreaWidgetContents);
	setLayout(verticalBox);
	
	if (treeWidget_ != NULL) {
		QTreeWidgetItem *item = treeWidget_->headerItem();

		for (unsigned i = 0; i < item->columnCount(); ++i) {
			cbox = new QCheckBox(item->text(i));
			grid_->addWidget(cbox, i, 0);
			treeWidget_->isColumnHidden(i) ? cbox->setCheckState(Qt::Unchecked) : cbox->setCheckState(Qt::Checked);
			checkBoxes_.push_back(cbox);
			cbox = NULL;
		}
	}
	
	dialogButtons_ = new QDialogButtonBox(this);
	dialogButtons_->setStandardButtons(QDialogButtonBox::Ok
	                                   | QDialogButtonBox::Cancel);	

	verticalBox->addWidget(dialogButtons_);
	
	connect(dialogButtons_, SIGNAL(clicked(QAbstractButton*)),
					this, SLOT(on_buttonClicked(QAbstractButton*)));
}


ColumnSelectorDialog::~ColumnSelectorDialog()
{
}


void ColumnSelectorDialog::on_buttonClicked(QAbstractButton *button)
{
	switch (dialogButtons_->buttonRole ( button ) ) {
	case QDialogButtonBox::AcceptRole :
		ApplySettings();
		done(QDialog::Accepted);
		break;
	case QDialogButtonBox::ApplyRole :
		ApplySettings();
		done(QDialog::Accepted);
		break;
	case QDialogButtonBox::RejectRole :
		done(QDialog::Rejected);
		break;
	default:
		return;
	}
}


void ColumnSelectorDialog::ApplySettings()
{
	if (treeWidget_ != NULL) {
		QTreeWidgetItem *item = treeWidget_->headerItem();
		QCheckBox *cbox = NULL;
		
		for (unsigned i = 0; i < checkBoxes_.size(); ++i) {
			cbox = checkBoxes_.at(i);
			cbox->isChecked() ? treeWidget_->showColumn(i) : treeWidget_->hideColumn(i);
			cbox = NULL;
		}
	}
}

