/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ALERTWAITERTHREAD_H
#define ALERTWAITERTHREAD_H

#include <QThread>
#include <QMutex>
#include "TorrentSession.hpp"

namespace qtrapids
{

/**
   @author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/
class AlertWaiterThread : public QThread
{
	Q_OBJECT

public:
	AlertWaiterThread(session_t *session, QObject *parent = 0);

	virtual ~AlertWaiterThread();

	void allAlerts(bool enable = true);

	virtual void run(); // Overridden from QThread
	
	virtual void stop();
	
signals:
	void alert();

private:
	session_t *const btSession_;
	bool running_;
	QMutex alertMutex_;
};

} // namespace qtrapids

#endif
