/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSettings>

#include "PluginInterface.h"
#include "proxy.h"

class QTabWidget;
class DownloadView;
class PreferencesDialog;

namespace qtrapids
{

class SeedView;

/**
   @author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/
class MainWindow : public QMainWindow, public PluginHostInterface 
{

	Q_OBJECT;

public:

	MainWindow();
	virtual ~MainWindow();

	// Implemented from PluginHostInterface
	virtual bool setGui(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE, qtrapids::PluginInterface* plugin = NULL);
	virtual void addPluginWidget(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
	virtual void addToolbar(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
	virtual void addToolItem(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
	virtual void addMenu(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
	virtual void addMenuItem(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
	virtual bool eventRequest(QVariant param, PluginRequest req = UNKNOWN_REQUEST);
	
	void RestoreSettings();

	void connectToServer() {
		qDBusRegisterMetaType<qtrapids::TorrentState>();
		qDBusRegisterMetaType<qtrapids::ParamsMap_t>();

		connect(&server_
		        , SIGNAL(alert(qtrapids::TorrentState
		                       , qtrapids::ParamsMap_t))
		        , this
		        , SLOT(on_alert(qtrapids::TorrentState
		                     , qtrapids::ParamsMap_t)));
		// Request server state. 
		// NOTE: This call starts qtrapids-server automatically with the GUI, 
		// if the .service file is in /usr/share/dbus-1/services/
		server_.getState();
	}

signals:
	void itemSelected(bool enabled);

public slots:
private slots:
	void on_openAction_clicked();
	void on_removeAction_clicked();
	void on_quitAction_clicked();
	void on_startDaemonAction_clicked();
	void on_stopDaemonAction_clicked();
	void on_serverTerminated();
	void on_columnsAction_clicked();
	void on_preferencesAction_clicked();
	void on_aboutAction_clicked();
	void on_aboutQtAction_clicked();
	void on_tabWidget_tabCloseRequested(int index);
	void on_downloadItemSelectionChanged();
	void on_seedItemSelectionChanged();
	void handleToolBarAction(QAction* action);
	void on_torrentFileSelected(QString file);
	void on_alert(qtrapids::TorrentState, qtrapids::ParamsMap_t);

	
private:
	void LoadPlugins();
	void StartTorrentFromBufferData(char const* data, int size);
		
private:
	QTabWidget *tabWidget_;
	DownloadView *dlView_;
	SeedView *seedView_;
	QWidget *searchWidget_;
	QAction *startDaemonAction_, *stopDaemonAction_;
	PreferencesDialog *preferencesDialog_;
	QSettings settings_;
	QList<QDir> pluginDirs_;
	QStringList pluginFileNames_;


	//std::vector< std::auto_ptr<QTorrentHandle> const > torrentHandles_;

	QtRapidsServer server_;


	//bool IsNewTorrent(std::auto_ptr<QTorrentHandle> handlePtr);
};

} // namespace qtrapids

#endif
