/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef COLUMNSELECTORDIALOG_H
#define COLUMNSELECTORDIALOG_H

#include <vector>
#include <QDialog>
#include <QSettings>

class QTreeWidget;
class QDialogButtonBox;
class QGridLayout;
class QTreeWidget;
class QCheckBox;
class QAbstractButton;
class QAbstractKineticScroller;


/**
   @author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
   @brief Dialog for selecting columns in QTreeViewWidget
*/
class ColumnSelectorDialog : public QDialog
{
	Q_OBJECT
	
	public:
		ColumnSelectorDialog(QTreeWidget *treewidget, QWidget* parent = 0, Qt::WindowFlags f = 0);
		virtual ~ColumnSelectorDialog();
	
	private slots:
		void on_buttonClicked(QAbstractButton *button);
		
	private:
		QDialogButtonBox *dialogButtons_;
		QGridLayout *grid_;
		QTreeWidget *treeWidget_;
		QAbstractKineticScroller *scroller_;
		std::vector<QCheckBox*> checkBoxes_;

	private:
		void ApplySettings();
	
};

#endif
