#include "mainwindow.h"
#include "ui_mainwindow.h"
//#include "ui_mainwindowvert.h"
#include <QMessageBox>
#include <QDesktopWidget>

bool ishexnstring(const QString& string)
{
  for (int i = 0; i < string.length(); i++) {
    if (isxdigit(string[i] == 0))
      return false;
  }
  return true;
}

QString unescapeJson( const QByteArray& ba, bool* ok )
{
  *ok = false;
  QString res;
  QByteArray seg;
  bool bs = false;
  for ( int i = 0, size = ba.size(); i < size; ++i ) {
    const char ch = ba[i];
    if ( !bs ) {
      if ( ch == '\\' )
        bs = true;
      else
        seg += ch;
    } else {
      bs = false;
      switch ( ch ) {
        case 'b':
          seg += '\b';
          break;
        case 'f':
          seg += '\f';
          break;
        case 'n':
          seg += '\n';
          break;
        case 'r':
          seg += '\r';
          break;
        case 't':
          seg += '\t';
          break;
        case 'u':
        {
          res += QString::fromUtf8( seg );
          seg.clear();

          if ( i > size - 5 ) {
            //error
            return QString();
          }

          const QString hex_digit1 = QString::fromUtf8( ba.mid( i + 1, 2 ) );
          const QString hex_digit2 = QString::fromUtf8( ba.mid( i + 3, 2 ) );
          i += 4;

          if ( !ishexnstring( hex_digit1 ) || !ishexnstring( hex_digit2 ) ) {
            qCritical() << "Not an hex string:" << hex_digit1 << hex_digit2;
            return QString();
          }
          bool hexOk;
          const ushort hex_code1 = hex_digit1.toShort( &hexOk, 16 );
          if (!hexOk) {
            qCritical() << "error converting hex value to short:" << hex_digit1;
            return QString();
          }
          const ushort hex_code2 = hex_digit2.toShort( &hexOk, 16 );
          if (!hexOk) {
            qCritical() << "error converting hex value to short:" << hex_digit2;
            return QString();
          }

          res += QChar(hex_code2, hex_code1);
          break;
        }
        case '\\':
          seg  += '\\';
          break;
        default:
          seg += ch;
          break;
      }
    }
  }
  res += QString::fromUtf8( seg );
  *ok = true;
  return res;
}

QString unescapeXML(const QString &str)
{
    QString data = str;
    data.replace( "&#39;", "'" );
    data.replace( "&quot;", "\"" );
    return data;
}

/************************ Main Window ********************************/

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    //uiVert(new Ui::MainWindowVert),
    inResizeEvent(false)
{
    //uiVert->setupUi(this);
    ui->setupUi(this);
    initLangCodes();
    _http = new QHttp(this);
    _toWindow = 0;

    connect(ui->actionLeft_from_clipboard, SIGNAL(triggered()), this, SLOT(leftFromClipboard()));
    connect(ui->actionRight_from_clipboard, SIGNAL(triggered()), this, SLOT(rightFromClipboard()));
    connect(ui->actionLeft_to_clipboard, SIGNAL(triggered()), this, SLOT(leftToClipboard()));
    connect(ui->actionRight_to_clipboard, SIGNAL(triggered()), this, SLOT(rightToClipboard()));
    connect(ui->buttonLeft_to_right, SIGNAL(clicked()), this, SLOT(translateLeftToRight()));
    connect(ui->buttonRight_to_left, SIGNAL(clicked()), this, SLOT(translateRightToLeft()));
    connect(ui->actionLeft_as_e_mail, SIGNAL(triggered()), this, SLOT(leftAsEmail()));
    connect(ui->actionRight_as_e_mail, SIGNAL(triggered()), this, SLOT(rightAsEmail()));
    connect(ui->actionLeft_as_sms, SIGNAL(triggered()), this, SLOT(leftAsSms()));
    connect(ui->actionRight_as_sms, SIGNAL(triggered()), this, SLOT(rightAsSms()));
    //connect(ui->actionLeft_clear, SIGNAL(triggered()), this, SLOT(leftClear()));
    //connect(ui->actionRight_clear, SIGNAL(triggered()), this, SLOT(rightClear()));
    connect(ui->buttonLeft_clear, SIGNAL(clicked()), this, SLOT(leftClear()));
    connect(ui->buttonRight_clear, SIGNAL(clicked()), this, SLOT(rightClear()));
    connect(ui->actionAbout_qtranslate, SIGNAL(triggered()), this, SLOT(aboutQTranslate()));
    connect(ui->actionDonate, SIGNAL(triggered()), this, SLOT(donate()));

    /*connect(uiVert->actionLeft_from_clipboard, SIGNAL(triggered()), this, SLOT(leftFromClipboard()));
    connect(uiVert->actionRight_from_clipboard, SIGNAL(triggered()), this, SLOT(rightFromClipboard()));
    connect(uiVert->actionLeft_to_clipboard, SIGNAL(triggered()), this, SLOT(leftToClipboard()));
    connect(uiVert->actionRight_to_clipboard, SIGNAL(triggered()), this, SLOT(rightToClipboard()));
    connect(uiVert->buttonLeft_to_right, SIGNAL(clicked()), this, SLOT(translateLeftToRight()));
    connect(uiVert->buttonRight_to_left, SIGNAL(clicked()), this, SLOT(translateRightToLeft()));
    connect(uiVert->actionLeft_as_e_mail, SIGNAL(triggered()), this, SLOT(leftAsEmail()));
    connect(uiVert->actionRight_as_e_mail, SIGNAL(triggered()), this, SLOT(rightAsEmail()));
    connect(uiVert->actionLeft_as_sms, SIGNAL(triggered()), this, SLOT(leftAsSms()));
    connect(uiVert->actionRight_as_sms, SIGNAL(triggered()), this, SLOT(rightAsSms()));
    //connect(ui->actionLeft_clear, SIGNAL(triggered()), this, SLOT(leftClear()));
    //connect(ui->actionRight_clear, SIGNAL(triggered()), this, SLOT(rightClear()));
    connect(uiVert->actionAbout_qtranslate, SIGNAL(triggered()), this, SLOT(aboutQTranslate()));
    connect(uiVert->actionDonate, SIGNAL(triggered()), this, SLOT(donate()));
    connect(uiVert->buttonLeft_clear, SIGNAL(clicked()), this, SLOT(leftClear()));
    connect(uiVert->buttonRight_clear, SIGNAL(clicked()), this, SLOT(rightClear()));*/

    connect(_http, SIGNAL(requestFinished(int,bool)), this, SLOT(translateRequestFinished(int,bool)));

    //loadSettings();
}

void MainWindow::saveSettings() {
    QSettings settings("Peter Bouda", "qTranslate");
    QString currentLeftLang = ui->comboboxLang_left->itemText(ui->comboboxLang_left->currentIndex());
    QString currentRightLang = ui->comboboxLang_right->itemText(ui->comboboxLang_right->currentIndex());
    settings.setValue("leftLanguage", currentLeftLang);
    settings.setValue("rightLanguage", currentRightLang);
}

void MainWindow::loadSettings() {
    QSettings settings("Peter Bouda", "qTranslate");
    QString currentLeftLang = settings.value("leftLanguage", "Afrikaans").toString();
    QString currentRightLang = settings.value("rightLanguage", "Afrikaans").toString();
    ui->comboboxLang_left->setCurrentIndex(ui->comboboxLang_left->findText(currentLeftLang));
    ui->comboboxLang_right->setCurrentIndex(ui->comboboxLang_right->findText(currentRightLang));
    //uiVert->comboboxLang_left->setCurrentIndex(ui->comboboxLang_left->findText(currentLeftLang));
    //uiVert->comboboxLang_right->setCurrentIndex(ui->comboboxLang_right->findText(currentRightLang));
}

void MainWindow::closeEvent(QCloseEvent *event)
 {
    saveSettings();
    event->accept();
 }

void MainWindow::donate()
{
    QMessageBox donate(this);
    donate.setTextFormat(Qt::RichText);
    donate.setWindowTitle(tr("Donate for qTranslate"));
    donate.setText(tr("Please donate as much as you like if you find this software useful.<br/><b>Do you want to donate via Paypal now?</b>"));
    donate.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    donate.setDefaultButton(QMessageBox::Yes);
    int ret = donate.exec();
    if (ret == QMessageBox::Yes)
        QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=VXN9T26P6HVLG"));
}

void MainWindow::aboutQTranslate()
{
    QMessageBox::information(this, tr("About qTranslate"),tr("qTranslate was developed by <a href=\"http://www.peterbouda.de\">Peter Bouda</a>. All rights reserverd. Contact me for development of Qt software and Ruby on Rails web applications: contact@peterbouda.de<br/>Get a free wiki at <a href=\"http://aufundapp.de/tor\">Tiddler on Rails</a>. Access it everywhere."));
}

void MainWindow::leftClear()
{
    ui->texteditLeft->clear();
}

void MainWindow::rightClear()
{
    ui->texteditRight->clear();
}

void MainWindow::leftAsSms()
{
    QString text = ui->texteditLeft->toPlainText();
    QDesktopServices::openUrl("sms:?body="+text);
}

void MainWindow::rightAsSms()
{
    QString text = ui->texteditRight->toPlainText();
    QDesktopServices::openUrl("sms:?body="+text);
}

void MainWindow::leftAsEmail()
{
    QString text = ui->texteditLeft->toPlainText();
    QDesktopServices::openUrl("mailto:?body="+text);
}

void MainWindow::rightAsEmail()
{
    QString text = ui->texteditRight->toPlainText();
    QDesktopServices::openUrl("mailto:?body="+text);
}

void MainWindow::translateLeftToRight()
{
    QString text = ui->texteditLeft->toPlainText();
    int iLangFrom = ui->comboboxLang_left->currentIndex();
    QString langFrom = ui->comboboxLang_left->itemData(iLangFrom).toString();
    int iLangTo = ui->comboboxLang_right->currentIndex();
    QString langTo = ui->comboboxLang_right->itemData(iLangTo).toString();
    if (langTo == "auto") {
            QMessageBox::critical(this, tr("Choose target language"),tr("Detecting the language is not possible for target language."));
    } else {
        _toWindow = 1;
        googleTranslate(text, langFrom, langTo);
    }

}

void MainWindow::translateRightToLeft()
{
    QString text = ui->texteditRight->toPlainText();
    int iLangFrom = ui->comboboxLang_right->currentIndex();
    QString langFrom = ui->comboboxLang_right->itemData(iLangFrom).toString();
    int iLangTo = ui->comboboxLang_left->currentIndex();
    QString langTo = ui->comboboxLang_left->itemData(iLangTo).toString();
    if (langTo == "auto") {
            QMessageBox::critical(this, tr("Choose target language"),tr("Detecting the language is not possible for target language."));
    } else {
        _toWindow = 0;
        googleTranslate(text, langFrom, langTo);
    }

}

void MainWindow::googleTranslate(QString text, QString langFrom, QString langTo)
{
    QHttpRequestHeader header("GET", "/ajax/services/language/translate?v=1.0&q="+QUrl::toPercentEncoding(text)+"&langpair="+langFrom+"%7C"+langTo);
    header.setValue("Host", "ajax.googleapis.com");
    _http->setHost("ajax.googleapis.com");
    header.setValue("User-Agent", "qTranslateForMaemo");
    header.setValue("Accept-Charset", "utf-8;q=0.7,*;q=0.7");
    header.setValue("Referer", "qTranslateForMaemo");

    /*QByteArray params("v=1.0");
    params.append("&q="+QUrl::toPercentEncoding(text));
    params.append("&langpair="+langFrom+"%7C"+langTo);
    qDebug(params);*/
    _translation = new QBuffer(this);
    _http->request(header, QByteArray(), _translation);
    //QMessageBox::information(this, tr("Tiddlers on Rails"),tr("Get a free wiki at <a href=\"http://aufundapp.de/tor\">Tiddler on Rails</a>. Access it everywhere."));
}

void MainWindow::leftFromClipboard()
{
    fromClipboard(0);
}

void MainWindow::rightFromClipboard()
{
    fromClipboard(1);
}

void MainWindow::leftToClipboard()
{
    toClipboard(0);
}

void MainWindow::rightToClipboard()
{
    toClipboard(1);
}

void MainWindow::fromClipboard(int side)
{
    QClipboard *clipboard = QApplication::clipboard();
    QString clipboardText = clipboard->text();
    if (side == 0)
        ui->texteditLeft->setText(clipboardText);
    else
        ui->texteditRight->setText(clipboardText);
}

void MainWindow::toClipboard(int side)
{
    QClipboard *clipboard = QApplication::clipboard();
    QString text;
    if (side == 0)
        text = ui->texteditLeft->toPlainText();
    else
        text = ui->texteditRight->toPlainText();
    clipboard->setText(text);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::resizeEvent(QResizeEvent* event) {
    /*if (!inResizeEvent) {
        inResizeEvent = true;
        saveSettings();
        QRect qs=QApplication::desktop()->availableGeometry();
        if(qs.height() > qs.width())
            uiVert->setupUi(this);
        else
            ui->setupUi(this);
        showMaximized();
        inResizeEvent = false;
        initLangCodes();
        loadSettings();
        qDebug() << "Rotated";
    }*/
}

void MainWindow::initLangCodes()
{
    QMap<QString, QString> langCodes;

    //ui->comboboxLang_left->addItem("Detect language", "auto");
    //ui->comboboxLang_right->addItem("Detect language", "auto");

    langCodes["af"] = "Afrikaans";
    langCodes["sq"] = "Albanian";
    langCodes["ar"] = "Arabic";
    langCodes["bg"] = "Bulgarian";
    langCodes["ca"] = "Catalan";
    langCodes["zh-CN"] = "Chinese";
    langCodes["hr"] = "Croatian";
    langCodes["cs"] = "Czech";
    langCodes["nl"] = "Dutch";
    langCodes["en"] = "English";
    langCodes["et"] = "Estonian";
    langCodes["fi"] = "Finnish";
    langCodes["fr"] = "French";
    langCodes["gl"] = "Galician";
    langCodes["de"] = "German";
    langCodes["el"] = "Greek";
    langCodes["iw"] = "Hebrew";
    langCodes["hi"] = "Hindi";
    langCodes["hu"] = "Hungarian";
    langCodes["is"] = "Icelandic";
    langCodes["id"] = "Indonesian";
    langCodes["ga"] = "Irish";
    langCodes["it"] = "Italian";
    langCodes["ja"] = "Japanese";
    langCodes["ko"] = "Korean";
    langCodes["lv"] = "Lettic";
    langCodes["lt"] = "Lithuanian";
    langCodes["mk"] = "Macedonian";
    langCodes["ms"] = "Malay";
    langCodes["mt"] = "Maltese";
    langCodes["no"] = "Norwegian";
    langCodes["fa"] = "Farsi";
    langCodes["pl"] = "Polish";
    langCodes["pt"] = "Portuguese";
    langCodes["ro"] = "Romanian";
    langCodes["ru"] = "Russian";
    langCodes["sr"] = "Serbian";
    langCodes["sk"] = "Slovakian";
    langCodes["sl"] = "Slovenian";
    langCodes["sv"] = "Swedish";
    langCodes["es"] = "Spanish";
    langCodes["sw"] = "Swahili";
    langCodes["tl"] = "Tagalog";
    langCodes["th"] = "Thai";
    langCodes["tr"] = "Turkish";
    langCodes["uk"] = "Ukrainian";
    langCodes["vi"] = "Vietnamese";
    langCodes["cy"] = "Welsh";
    langCodes["yi"] = "Yiddish";


    QMapIterator<QString, QString> i(langCodes);
    while (i.hasNext()) {
         i.next();
         ui->comboboxLang_left->addItem(i.value(), i.key());
         ui->comboboxLang_right->addItem(i.value(), i.key());
         //uiVert->comboboxLang_left->addItem(i.value(), i.key());
         //uiVert->comboboxLang_right->addItem(i.value(), i.key());
    }
}

void MainWindow::translateRequestFinished(int requestId, bool error)
 {
    if (error) {
        QMessageBox::information(this, tr("HTTP"),
                                  tr("Translation failed: %1.")
                                  .arg(_http->errorString()));
    } else {
        bool ok = false;
        QString jsonTranslation = unescapeJson(_translation->data(), &ok).trimmed();
        qDebug() << jsonTranslation;
        QString translation = QString("");
        QRegExp regexp = QRegExp("\"translatedText\":\"(.*)\"");
        regexp.setPatternSyntax(QRegExp::RegExp2);
        regexp.setMinimal(true);
        if (jsonTranslation.contains(regexp))
        {
            translation = regexp.cap(1);
            translation = unescapeXML(translation);
            qDebug() << translation;
            //translation = translation.fromUtf8(translation);
        }
        else
        {
            qDebug("not found");
        }

        if (_toWindow == 0)
            ui->texteditLeft->setText(translation);
        else
            ui->texteditRight->setText(translation);
    }
}

