/**************************************************************************
**
** Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** GNU Lesser General Public License Usage
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**************************************************************************/

#include "qtquickcompat_plugin.h"

#include <QSystemInfo>

#include <QtDeclarative/QtDeclarative>

#include "private/qdeclarativevaluetype_p.h"

#ifndef QT_NO_MOVIE
#include "private/qdeclarativeanimatedimage_p.h"
#endif
#include "private/qdeclarativeborderimage_p.h"
#include "private/qdeclarativepositioners_p.h"
#include "private/qdeclarativemousearea_p.h"
#include "private/qdeclarativeflickable_p.h"
#include "private/qdeclarativeflipable_p.h"
#include "private/qdeclarativefocuspanel_p.h"
#include "private/qdeclarativefocusscope_p.h"
#include "private/qdeclarativerectangle_p.h"
#include "private/qdeclarativegridview_p.h"
#include "private/qdeclarativelayoutitem_p.h"
#include "private/qdeclarativelistview_p.h"
#include "private/qdeclarativeloader_p.h"
#include "private/qdeclarativepath_p.h"
#include "private/qdeclarativepathview_p.h"
#include "private/qdeclarativerepeater_p.h"
#include "private/qdeclarativetext_p.h"
#include "private/qdeclarativetextedit_p.h"
#include "private/qdeclarativetextinput_p.h"
#include "private/qdeclarativetranslate_p.h"
#include "private/qdeclarativevisualitemmodel_p.h"
#include "private/qdeclarativegraphicswidget_p.h"
#include "private/qdeclarativeitem_p.h"
#include "private/qdeclarativeevents_p_p.h"
#include "private/qdeclarativescalegrid_p_p.h"
#include "private/qdeclarativeflickable_p_p.h"

#include "private/qdeclarativeworkerscript_p.h"
#include "private/qdeclarativebinding_p.h"

static QDeclarativePrivate::AutoParentResult qgraphicsobject_autoParent(QObject *obj, QObject *parent)
{
    QGraphicsObject* gobj = qobject_cast<QGraphicsObject*>(obj);
    if (!gobj)
        return QDeclarativePrivate::IncompatibleObject;

    QGraphicsObject* gparent = qobject_cast<QGraphicsObject*>(parent);
    if (!gparent)
        return QDeclarativePrivate::IncompatibleParent;

    gobj->setParentItem(gparent);
    return QDeclarativePrivate::Parented;
}

template<typename T>
int qmlRegisterValueTypeEnums(const char *uri, int versionMajor, int versionMinor, const char *qmlName)
{
    QByteArray name(T::staticMetaObject.className());

    QByteArray pointerName(name + '*');

    QDeclarativePrivate::RegisterType type = {
        0,

        qRegisterMetaType<T *>(pointerName.constData()), 0, 0, 0,

        QString(),

        uri, versionMajor, versionMinor, qmlName, &T::staticMetaObject,

        0, 0,

        0, 0, 0,

        0, 0,

        0
    };

    return QDeclarativePrivate::qmlregister(QDeclarativePrivate::TypeRegistration, &type);
}


// QDeclarativeValueType::declarativeValueTypes
void QtQuickCompatPlugin::declarativeValueTypes()
{
    qmlRegisterValueTypeEnums<QDeclarativeEasingValueType>("QtQuick",1,0, "Easing");
    qmlRegisterValueTypeEnums<QDeclarativeFontValueType>("QtQuick",1,0, "Font");
}

// QDeclarativeItemModule::defineModule
void QtQuickCompatPlugin::declarativeItemModule()
{
    QDeclarativePrivate::RegisterAutoParent autoparent = { 0, &qgraphicsobject_autoParent };
    QDeclarativePrivate::qmlregister(QDeclarativePrivate::AutoParentRegistration, &autoparent);

#ifdef QT_NO_MOVIE
    qmlRegisterTypeNotAvailable("QtQuick",1,0,"AnimatedImage",
        qApp->translate("QDeclarativeAnimatedImage","Qt was built without support for QMovie"));
#else
    qmlRegisterType<QDeclarativeAnimatedImage>("QtQuick",1,0,"AnimatedImage");
#endif
    qmlRegisterType<QDeclarativeBorderImage>("QtQuick",1,0,"BorderImage");
    qmlRegisterType<QDeclarativeColumn>("QtQuick",1,0,"Column");
    qmlRegisterType<QDeclarativeDrag>("QtQuick",1,0,"Drag");
    qmlRegisterType<QDeclarativeFlickable>("QtQuick",1,0,"Flickable");
    qmlRegisterType<QDeclarativeFlipable>("QtQuick",1,0,"Flipable");
    qmlRegisterType<QDeclarativeFlow>("QtQuick",1,0,"Flow");
    qmlRegisterType<QDeclarativeFocusPanel>("QtQuick",1,0,"FocusPanel");
    qmlRegisterType<QDeclarativeFocusScope>("QtQuick",1,0,"FocusScope");
    qmlRegisterType<QDeclarativeGradient>("QtQuick",1,0,"Gradient");
    qmlRegisterType<QDeclarativeGradientStop>("QtQuick",1,0,"GradientStop");
    qmlRegisterType<QDeclarativeGrid>("QtQuick",1,0,"Grid");
    qmlRegisterType<QDeclarativeGridView>("QtQuick",1,0,"GridView");
    qmlRegisterType<QDeclarativeImage>("QtQuick",1,0,"Image");
    qmlRegisterType<QDeclarativeItem>("QtQuick",1,0,"Item");
    qmlRegisterType<QDeclarativeLayoutItem>("QtQuick",1,0,"LayoutItem");
    qmlRegisterType<QDeclarativeListView>("QtQuick",1,0,"ListView");
    qmlRegisterType<QDeclarativeLoader>("QtQuick",1,0,"Loader");
    qmlRegisterType<QDeclarativeMouseArea>("QtQuick",1,0,"MouseArea");
    qmlRegisterType<QDeclarativePath>("QtQuick",1,0,"Path");
    qmlRegisterType<QDeclarativePathAttribute>("QtQuick",1,0,"PathAttribute");
    qmlRegisterType<QDeclarativePathCubic>("QtQuick",1,0,"PathCubic");
    qmlRegisterType<QDeclarativePathLine>("QtQuick",1,0,"PathLine");
    qmlRegisterType<QDeclarativePathPercent>("QtQuick",1,0,"PathPercent");
    qmlRegisterType<QDeclarativePathQuad>("QtQuick",1,0,"PathQuad");
    qmlRegisterType<QDeclarativePathView>("QtQuick",1,0,"PathView");
#ifndef QT_NO_VALIDATOR
    qmlRegisterType<QIntValidator>("QtQuick",1,0,"IntValidator");
    qmlRegisterType<QDoubleValidator>("QtQuick",1,0,"DoubleValidator");
    qmlRegisterType<QRegExpValidator>("QtQuick",1,0,"RegExpValidator");
#endif
    qmlRegisterType<QDeclarativeRectangle>("QtQuick",1,0,"Rectangle");
    qmlRegisterType<QDeclarativeRepeater>("QtQuick",1,0,"Repeater");
    qmlRegisterType<QGraphicsRotation>("QtQuick",1,0,"Rotation");
    qmlRegisterType<QDeclarativeRow>("QtQuick",1,0,"Row");
    qmlRegisterType<QDeclarativeTranslate>("QtQuick",1,0,"Translate");
    qmlRegisterType<QGraphicsScale>("QtQuick",1,0,"Scale");
    qmlRegisterType<QDeclarativeText>("QtQuick",1,0,"Text");
    qmlRegisterType<QDeclarativeTextEdit>("QtQuick",1,0,"TextEdit");
    qmlRegisterType<QDeclarativeTextInput>("QtQuick",1,0,"TextInput");
    qmlRegisterType<QDeclarativeViewSection>("QtQuick",1,0,"ViewSection");
    qmlRegisterType<QDeclarativeVisualDataModel>("QtQuick",1,0,"VisualDataModel");
    qmlRegisterType<QDeclarativeVisualItemModel>("QtQuick",1,0,"VisualItemModel");

    qmlRegisterType<QDeclarativeAnchors>();
    qmlRegisterType<QDeclarativeKeyEvent>();
    qmlRegisterType<QDeclarativeMouseEvent>();
    qmlRegisterType<QGraphicsObject>();
    qmlRegisterType<QGraphicsWidget>("QtQuick",1,0,"QGraphicsWidget");
    qmlRegisterExtendedType<QGraphicsWidget,QDeclarativeGraphicsWidget>("QtQuick",1,0,"QGraphicsWidget");
    qmlRegisterType<QGraphicsTransform>();
    qmlRegisterType<QDeclarativePathElement>();
    qmlRegisterType<QDeclarativeCurve>();
    qmlRegisterType<QDeclarativeScaleGrid>();
#ifndef QT_NO_VALIDATOR
    qmlRegisterType<QValidator>();
#endif
    qmlRegisterType<QDeclarativeVisualModel>();
#ifndef QT_NO_ACTION
    qmlRegisterType<QAction>();
#endif
    qmlRegisterType<QDeclarativePen>();
    qmlRegisterType<QDeclarativeFlickableVisibleArea>();
#ifndef QT_NO_GRAPHICSEFFECT
    qmlRegisterType<QGraphicsEffect>();
#endif

    qmlRegisterUncreatableType<QDeclarativeKeyNavigationAttached>("QtQuick",1,0,"KeyNavigation",QDeclarativeKeyNavigationAttached::tr("KeyNavigation is only available via attached properties"));
    qmlRegisterUncreatableType<QDeclarativeKeysAttached>("QtQuick",1,0,"Keys",QDeclarativeKeysAttached::tr("Keys is only available via attached properties"));
}

void QtQuickCompatPlugin::engineModule()
{
    qmlRegisterType<QDeclarativeComponent>("QtQuick",1,0,"Component");
    qmlRegisterType<QObject>("QtQuick",1,0,"QtObject");
    qmlRegisterType<QDeclarativeWorkerScript>("QtQuick",1,0,"WorkerScript");

    qmlRegisterType<QDeclarativeBinding>();
}


#include "private/qdeclarativeanimation_p.h"
#include "private/qdeclarativestateoperations_p.h"
#include "private/qdeclarativebehavior_p.h"
#include "private/qdeclarativebind_p.h"
#include "private/qdeclarativeconnections_p.h"
#include "private/qdeclarativesmoothedanimation_p.h"
#include "private/qdeclarativefontloader_p.h"
#include "private/qdeclarativelistmodel_p.h"
#include "private/qdeclarativespringanimation_p.h"
#include "private/qdeclarativesystempalette_p.h"
#include "private/qdeclarativetimer_p.h"
#ifndef QT_NO_XMLPATTERNS
#include "private/qdeclarativexmllistmodel_p.h"
#endif
#include "private/qdeclarativepropertychanges_p.h"
#include "private/qdeclarativepackage_p.h"
#include "private/qdeclarativestategroup_p.h"
#include "private/qdeclarativecomponent_p.h"

void QtQuickCompatPlugin::utilModule()
{
    qmlRegisterType<QDeclarativeAnchorAnimation>("QtQuick",1,0,"AnchorAnimation");
    qmlRegisterType<QDeclarativeAnchorChanges>("QtQuick",1,0,"AnchorChanges");
    qmlRegisterType<QDeclarativeBehavior>("QtQuick",1,0,"Behavior");
    qmlRegisterType<QDeclarativeBind>("QtQuick",1,0,"Binding");
    qmlRegisterType<QDeclarativeColorAnimation>("QtQuick",1,0,"ColorAnimation");
    qmlRegisterType<QDeclarativeConnections>("QtQuick",1,0,"Connections");
    qmlRegisterType<QDeclarativeSmoothedAnimation>("QtQuick",1,0,"SmoothedAnimation");
    qmlRegisterType<QDeclarativeFontLoader>("QtQuick",1,0,"FontLoader");
    qmlRegisterType<QDeclarativeListElement>("QtQuick",1,0,"ListElement");
    qmlRegisterType<QDeclarativeNumberAnimation>("QtQuick",1,0,"NumberAnimation");
    qmlRegisterType<QDeclarativePackage>("QtQuick",1,0,"Package");
    qmlRegisterType<QDeclarativeParallelAnimation>("QtQuick",1,0,"ParallelAnimation");
    qmlRegisterType<QDeclarativeParentAnimation>("QtQuick",1,0,"ParentAnimation");
    qmlRegisterType<QDeclarativeParentChange>("QtQuick",1,0,"ParentChange");
    qmlRegisterType<QDeclarativePauseAnimation>("QtQuick",1,0,"PauseAnimation");
    qmlRegisterType<QDeclarativePropertyAction>("QtQuick",1,0,"PropertyAction");
    qmlRegisterType<QDeclarativePropertyAnimation>("QtQuick",1,0,"PropertyAnimation");
    qmlRegisterType<QDeclarativeRotationAnimation>("QtQuick",1,0,"RotationAnimation");
    qmlRegisterType<QDeclarativeScriptAction>("QtQuick",1,0,"ScriptAction");
    qmlRegisterType<QDeclarativeSequentialAnimation>("QtQuick",1,0,"SequentialAnimation");
    qmlRegisterType<QDeclarativeSpringAnimation>("QtQuick",1,0,"SpringAnimation");
    qmlRegisterType<QDeclarativeStateChangeScript>("QtQuick",1,0,"StateChangeScript");
    qmlRegisterType<QDeclarativeStateGroup>("QtQuick",1,0,"StateGroup");
    qmlRegisterType<QDeclarativeState>("QtQuick",1,0,"State");
    qmlRegisterType<QDeclarativeSystemPalette>("QtQuick",1,0,"SystemPalette");
    qmlRegisterType<QDeclarativeTimer>("QtQuick",1,0,"Timer");
    qmlRegisterType<QDeclarativeTransition>("QtQuick",1,0,"Transition");
    qmlRegisterType<QDeclarativeVector3dAnimation>("QtQuick",1,0,"Vector3dAnimation");
#ifdef QT_NO_XMLPATTERNS
    qmlRegisterTypeNotAvailable("QtQuick",1,0,"XmlListModel",
        qApp->translate("QDeclarativeXmlListModel","Qt was built without support for xmlpatterns"));
    qmlRegisterTypeNotAvailable("QtQuick",1,0,"XmlRole",
        qApp->translate("QDeclarativeXmlListModel","Qt was built without support for xmlpatterns"));
#else
    qmlRegisterType<QDeclarativeXmlListModel>("QtQuick",1,0,"XmlListModel");
    qmlRegisterType<QDeclarativeXmlListModelRole>("QtQuick",1,0,"XmlRole");
#endif

    qmlRegisterType<QDeclarativeAnchors>();
    qmlRegisterType<QDeclarativeStateOperation>();
    qmlRegisterType<QDeclarativeAnchorSet>();

    qmlRegisterUncreatableType<QDeclarativeAbstractAnimation>("QtQuick",1,0,"Animation",QDeclarativeAbstractAnimation::tr("Animation is an abstract class"));

    qmlRegisterCustomType<QDeclarativeListModel>("QtQuick",1,0, "ListModel", new QDeclarativeListModelParser);
    qmlRegisterCustomType<QDeclarativePropertyChanges>("QtQuick",1,0, "PropertyChanges", new QDeclarativePropertyChangesParser);
    qmlRegisterCustomType<QDeclarativeConnections>("QtQuick",1,0, "Connections", new QDeclarativeConnectionsParser);
}

void QtQuickCompatPlugin::registerTypes(const char * /*uri*/)
{
    QtMobility::QSystemInfo systemInfo;
    if (systemInfo.version(QtMobility::QSystemInfo::QtCore) != "4.7.0") {
        // Sanity check: 4.7.1 has the QtQuick namespace already built in.
        return;
    }

    declarativeValueTypes();
    declarativeItemModule();
    engineModule();
    utilModule();
}

Q_EXPORT_PLUGIN2(QtQuickCompat, QtQuickCompatPlugin)

