#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QProcess>
#include <QDialog>
#include <QMessageBox>
#include <QErrorMessage>
#include <QInputDialog>
#include <QFormLayout>
#include <QFile>
#include <QDir>
#include <QTextStream>
#include <QComboBox>
#include <iostream>
#include <fstream>
#include <QtWebKit/QWebView>
#include <QTimer>
#include <QtNetwork/QHttp>
#include <QBuffer>
#include <QtWebKit/QWebFrame>
#include <QtWebKit/QtWebKit>

using namespace std;

namespace Ui
{
    class PianobarQtClass;
}

class PianobarQt : public QMainWindow
{
    Q_OBJECT

public:
    PianobarQt(QWidget *parent = 0);
    ~PianobarQt();

private:
    Ui::PianobarQtClass *ui;
    QProcess process;
    QString output;
    QString btnTxt;
    QFile control;
    ofstream ctrl;
    QStringList stationList;
    bool stationsPopulated;
    bool playing;
    bool paused;
    bool stationChanged;
    QIcon pause;
    QIcon play;
    QIcon skip;
    QIcon skipping;
    QIcon favour;
    QIcon fav;
    QIcon banning;
    QIcon ban;
    QByteArray selected;
    QRegExp stripSong;
    QRegExp stripNext;
    QRegExp songFavoured;
    QRegExp rxlen;
    QRegExp stripTimeLeft;
    QRegExp stripAscii;
    QStringList stations;
    QLineEdit *username;
    QDialog *input;
    QLineEdit *password;
    QString nextSong;
    QString message;
    QTimer *timer;
    QWebView *tmpView;

private slots:
    void on_pushButton_next_clicked();
    void on_pushButton_next_pressed();
    void on_pushButton_next_released();

    void on_pushButton_ban_clicked();
    void on_pushButton_ban_released();
    void on_pushButton_ban_pressed();

    void on_pushButton_favourite_released();
    void on_pushButton_favourite_pressed();
    void on_pushButton_favourite_clicked();

    void on_pushButton_playpause_clicked();

    void set_usernamePassword();

    //    void on_cmdExec_finish();
    void scroll_output();
    void on_cmdExec_data_available();
    void on_webView_loadFinished();

    void save_Username_password();

    void comboxBox_stations_currentIndexChanged(QString);
};

#endif // MAINWINDOW_H
