#include "mainwindow.h"
#include "ui_mainwindow.h"

//using namespace std;

PianobarQt::PianobarQt(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::PianobarQtClass) {
    ui->setupUi(this);

    //////// connect signals

    connect(&process, SIGNAL(readyReadStandardOutput()), this, SLOT(on_cmdExec_data_available()));
    connect(&process, SIGNAL(finished(int)), this, SLOT(on_cmdExec_finish()));
    connect(ui->comboBox_stations,SIGNAL(currentIndexChanged(QString)),this,SLOT(comboxBox_stations_currentIndexChanged(QString)));
    ////////////////////////

    playing = false;
    paused = false;
    stationChanged = false;
    stationsPopulated = false;

    play = QIcon(":/images/images/playing.png");
    skipping = QIcon(":/images/images/skip-active.png");
    skip = QIcon(":/images/images/skip.png");
    pause = QIcon(":/images/images/paused.png");
    ban = QIcon(":/images/images/minus.png");
    banning = QIcon(":/images/images/minus-active.png");

    fav = QIcon(":/images/images/plus.png");
    favour = QIcon(":/images/images/plus-active.png");

    QString cmd = "pianobar";
    process.start(cmd);

    stripSong.setPattern(".*>\\s+\".*\" by");
    songFavoured.setPattern(".* <3");
    rxlen.setPattern(".*Ok.*\\d+");
    stripTimeLeft.setPattern("#\\s+-\\d+.*/\\d+");

}

PianobarQt::~PianobarQt() {
    delete ui;
}

void PianobarQt::on_pushButton_next_clicked() {
    ui->textEdit_output->clear();
    ui->textEdit_output->append("Song Skipped");
    process.write("n\n");
    if(paused) {
        process.write("p\n");
    }
}

void PianobarQt::on_pushButton_next_pressed() {
    ui->pushButton_next->setIcon(skipping);
}

void PianobarQt::on_pushButton_next_released() {
    ui->pushButton_next->setIcon(skip);
}

void PianobarQt::on_pushButton_favourite_clicked() {
    ui->textEdit_output->clear();
    ui->textEdit_output->append("Song Favoured");
    process.write("+\n");
}

void PianobarQt::on_pushButton_favourite_pressed() {
    ui->pushButton_favourite->setIcon(favour);
}

void PianobarQt::on_pushButton_favourite_released() {
    //        ui->pushButton_favourite->setIcon(fav);
}

void PianobarQt::on_pushButton_ban_clicked() {
    ui->textEdit_output->clear();
    ui->textEdit_output->append("Song Banned");
    process.write("-\n");     
}

void PianobarQt::on_pushButton_ban_released() {
    ui->pushButton_ban->setIcon(ban);
}

void PianobarQt::on_pushButton_ban_pressed() {
    ui->pushButton_ban->setIcon(banning);
}

void PianobarQt::on_pushButton_playpause_clicked() {
    if(playing) {
        ui->pushButton_playpause->setIcon(pause);
        playing = false;
        paused = true;
    } else
    {
        ui->pushButton_playpause->setIcon(play);
        playing = true;
        paused = false;
    }
    process.write("p\n");
}


void PianobarQt::on_cmdExec_finish() {
    ui->textEdit_output->clear();
}

//void MainWindow::on_pushButton_quit_clicked() {
//
//    process.write("q\n");
//    ui->pushButton_favourite->setDisabled(true);
//    ui->pushButton_next->setDisabled(true);
//    ui->pushButton_quit->setDisabled(true);
//}

void PianobarQt::comboxBox_stations_currentIndexChanged(QString item) {

    if(ui->comboBox_stations->currentIndex() != 0)
        if(stationsPopulated) {

        selected = QByteArray(QString::number(ui->comboBox_stations->currentIndex() - 1).toLocal8Bit()+"\n");
        if(playing || paused) {
            //            ui->textEdit_output->append("Chose: "+item+" at "+QString::number(ui->comboBox_stations->currentIndex()));
            process.write("q\n");
            process.close();
            ui->lcdNumber_timeLeft->display(QString("00:00"));
            ui->lcdNumber_totalTime->display(QString("00:00"));
            QString cmd = "pianobar";
            process.start(cmd);
            stationChanged = true;
        } else {
            process.write(selected);
            ui->pushButton_playpause->setIcon(play);
            playing = true;
        }
        ui->pushButton_favourite->setDisabled(false);
        ui->pushButton_ban->setDisabled(false);
        ui->pushButton_next->setDisabled(false);
        //        ui->pushButton_quit->setDisabled(false);
        ui->pushButton_playpause->setDisabled(false);
    }

}

void PianobarQt::on_cmdExec_data_available() {
    QByteArray stuff =  process.readAllStandardOutput();
    QString output(stuff);
    //    ui->textEdit_output->append("OUTPUT = "+output);
    if(stationChanged) {
        ui->textEdit_output->clear();
        ui->textEdit_output->append("Changing Station");
        process.write(selected);
        stationChanged = false;
        if(paused) {
            process.write("p\n");
        } else
            playing = true;
    }

    if(output.contains(stripSong)) {
        if(output.contains(songFavoured)) {
            ui->pushButton_favourite->setIcon(favour);
        } else
        {
            ui->pushButton_favourite->setIcon(fav);
        }
        QStringList song = output.split(">");
        QStringList songComponents = QString(song.at(1)).split("\"");
        ui->label_songTitle->setText(QString(songComponents.at(1)));
        ui->label_artist->setText(QString(songComponents.at(3)));
        ui->label_album->setText(QString(songComponents.at(5)));
    }

    if(output.contains(stripTimeLeft)) {
        QStringList timeLeft = output.split("/");
        ui->lcdNumber_timeLeft->display(QString(timeLeft.at(0)).remove("-"));
        ui->lcdNumber_totalTime->display(QString(timeLeft.at(1)));
    }

    Q_ASSERT(rxlen.isValid());

    if (output.contains(rxlen)) {
        stations = output.split("\n");

        if(!stationsPopulated) {
            for (int i = 0;i < stations.size()-1;i++) {
                QString station(stations.at(i+1));
                rxlen.setPattern(".*\\d+");
                if(station.contains(rxlen)) {
                    int start = station.indexOf(')',0,Qt::CaseInsensitive);
                    int end = station.length();
                    QString stationName = station.mid(start+4,end);
                    ui->comboBox_stations->addItem(stationName,QVariant(i+1));
                }
            }
            ui->comboBox_stations->setEnabled(true);
            stationsPopulated = true;
        }
    }
}
