#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "pluginconfiguration.h"


PluginConfiguration::PluginConfiguration(MobileHotspotPluginHelper *helper){
	this->helper = helper; // register our helper, it is useful for loading/saving and such
}

PluginConfiguration::~PluginConfiguration(){
	// helper deletion is handled by plugin itself, no need to destroy it here
}

void PluginConfiguration::load(){
	// Load the plugin's configuration, please use the helper function load("settingName", "defaultValue")
	// some_variable = helper->load("settingName", "default value").toString();
	QString mode = helper->load("mode", "disabled").toString();
	if(mode == "allow")
		filterMode =  MODE_ALLOW;
	else if(mode == "deny")
		filterMode = MODE_DENY;
	else
		filterMode = MODE_DISABLED;
	mactable = helper->load("mactable", QStringList()).toStringList();
}

void PluginConfiguration::save(){
	// Save the plugin's configuration, please use the helper function save("settingName", value)
	// helper->save("settingName", some_variable);
	QString mode;
	if(filterMode == MODE_ALLOW)
		mode = "allow";
	else if(filterMode == MODE_DENY)
		mode = "deny";
	else
		mode = "disabled";
	helper->save("mode", mode);
	helper->save("mactable", mactable);
}
