#include <QtCore/QObject>
#include <QtGui/QMessageBox>
#include <QtCore/qplugin.h>
#include <QtCore/QString>
#include <QtCore/QStringListIterator>
#include <QtCore/QTranslator>
#include "../../qtMobileHotspot/src/mobilehotspotplugin.h"
#include "../../qtMobileHotspot/src/mobilehotspotconfiguration.h"
#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "../../qtMobileHotspot/src/commandhelper.h"
#include "pluginconfiguration.h"
#include "plugingui.h"
#include "plugin.h"


Plugin::Plugin(){
	helper = new MobileHotspotPluginHelper(this); // create the helper for this plugin
	conf = new PluginConfiguration(helper); // create the configuration of this plugin
	conf->load(); // load plugin's configuration (see PluginConfiguration::load())
}

Plugin::~Plugin(){
	delete conf; // delete this plugin's configuration
	delete helper; // delete this plugin's helper
	delete translater; // delete this plugin's translator (even if there is no translation)
}

QString Plugin::name(){
	return "org.dest.qtmh.iptablesfix"; // unique name of the plugin, wont be displayed
}

QString Plugin::displayedName(){
	return tr("Iptables Tweaker"); // displayed name in the application menu (if applyable)
}

bool Plugin::displayNameStopped(){
	return true; // get (or not) an entry in the application menu while hotspot is stopped
}

bool Plugin::displayNameRunning(){
	return false; // get (or not) an entry in the application menu while hotspot is active
}

int Plugin::order(){
	// Plugins call ordering
	// Range should be 0..100 (included)
	// Startup calls are done in natural order (0, 1, ..., 100)
	// Shutdown calls are done in reverse order (100, 99, ..., 0)
	// Ranges 0..20 and 80..100 (included) should be reserved to 'official' plugins.
	return 80; // Iptables fixes are not that important and can be run later
}

void Plugin::configure(const MobileHotspotConfiguration &configuration, const bool running){
	// Plugin's entry in the application menu has been clicked
	PluginGUI gui; // create the GUI
	gui.setConfiguration(*conf); // load plugin configuration into the GUI
	if(gui.exec() != gui.Accepted) // display the GUI
		return;
	gui.configuration(conf); // get plugin configuration from the GUI
	conf->save(); // save plugin's configuration (see PluginConfiguration::save())
}

void Plugin::beforeStarting(const MobileHotspotConfiguration &configuration){
	// Run before the startup of the hotspot

}

void Plugin::afterStarting(const MobileHotspotConfiguration &configuration, const bool successStarting){
	// Run after the startup of the hotspot
	if(! successStarting)
		return;
	QString mac = lanMac(configuration);
	QStringListIterator iterator(conf->list);
	while(iterator.hasNext()){
		QString action = iterator.next();
		action = action.replace("$NETIF$", configuration.internetInterface());
		action = action.replace("$LANIF$", configuration.lanInterface);
		action = action.replace("$LANNET$", configuration.lanNetwork + "0/24");
		action = action.replace("$LANIP$", configuration.lanNetwork + "1");
		action = action.replace("$LANBROAD$", configuration.lanNetwork + "255");
		action = action.replace("$LANMAC$", mac);
		QString cmd("/usr/sbin/iptables "); cmd += action;
		int ret;
		bool res = CommandHelper::executeCommand(cmd, &ret);
		if( (! res) || (res && ret != 0) )
			qDebug("IPTABLESFIX : Last command failed");
	}
}

void Plugin::beforeStopping(const MobileHotspotConfiguration &configuration, const bool successStarting){
	// Run before the shutdown of the hotspot

}

void Plugin::afterStopping(const MobileHotspotConfiguration & configuration, const bool successStarting, const bool successFinishing){
	// Run after the shutdown of the hotspot

}

QString Plugin::lanMac(const MobileHotspotConfiguration &configuration){
	bool res;
	int ret;
	QString stdout;
	res = CommandHelper::executeCommandWithStdOut("/bin/sh -c \"ifconfig " + configuration.lanInterface + " | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'\"" , &ret, &stdout);
	if( (! res) || ret != 0){
		QString("IPTABLESFIX : FAILURE : Cannot get LAN MAC");
		return "";
	}

	return stdout;
}

QTranslator* Plugin::translator(){
	// Translations need
	// Should be kept as is, even if there are no translations
	return translater;
}

void Plugin::setTranslator(QTranslator *translater){
	// Translations need
	// Should be kept as is, even if there are no translations
	this->translater = translater;
}


Q_EXPORT_PLUGIN2(qtmhiptablesfix, Plugin); // 1st is target name, 2nd is class name
