/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "titlebar.h"
#include "settings.h"
#include "pixmaploader.h"

#include <QFont>
#include <QCoreApplication>

// CloseButton

CloseButton::CloseButton(QGraphicsItem *parent)
    : PixmapButton(80.0, PixmapLoader::getPic("button_close"), parent)
{
}

void CloseButton::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
    QCoreApplication::instance()->quit();
}

TitleBar::TitleBar(QGraphicsItem *parent)
    : QGraphicsPixmapItem(PixmapLoader::getPic("title_bar"), parent)
{
    QGraphicsTextItem *text = new QGraphicsTextItem(this);
    QFont font = text->font();
    font.setFamily("Nokia sans regular");
    font.setPixelSize(Settings::scaleHeight(25));
    text->setFont(font);
    text->setDefaultTextColor(QColor("white"));
    text->setPlainText("Weather");
    QRectF rect(boundingRect());
    qreal x = rect.left() + (rect.width() - text->boundingRect().width()) / 2;
    text->setPos(x, Settings::scaleHeight(5.0));

    CloseButton *button = new CloseButton(this);
    button->setPos(Settings::scaleWidth(442.0), Settings::scaleHeight(14.0));
}

int TitleBar::loadImages()
{
    PixmapLoader::load("button_close");
    PixmapLoader::load("title_bar");
    return 2;
}
