/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef SCROLLBAR_H
#define SCROLLBAR_H

#include <QTimer>
#include <QPointer>
#include <QGraphicsPixmapItem>
#include <QAbstractAnimation>

class ScrollBar: public QObject, public QGraphicsPixmapItem
{
    Q_OBJECT
    Q_PROPERTY(qreal opacity READ opacity WRITE setOpacity);
public:
    ScrollBar(QGraphicsItem* parent = 0);
    qreal value() const { return m_value; }
    void setValue(qreal);
    static int loadImages();

private slots:
    void timeout() { startAnimation(false); }
    void hideScrollBar() { hide(); }

private:
    QGraphicsPixmapItem m_knob;
    const qreal m_height;
    qreal m_value;
    QTimer m_timer;
    QPointer<QAbstractAnimation> m_animation;
    bool m_visible;

    bool startAnimation(bool show);
};

#endif /* SCROLLBAR_H */
