#ifndef PIXMAPBUTTON_H
#define PIXMAPBUTTON_H

#include <QObject>
#include <QGraphicsPixmapItem>

class PixmapButton: public QObject, public QGraphicsPixmapItem
{
    Q_OBJECT
    Q_PROPERTY(qreal opacity READ opacity WRITE setOpacity);
public:
    PixmapButton(qreal minSize, const QPixmap &pixmap, QGraphicsItem *parent = 0);
    QRectF boundingRect() const;
    QPainterPath shape() const;

public slots:
    void doHide() { hide(); }

signals:
    void clicked();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

private:
    const qreal m_minSize;
};

#endif // PIXMAPBUTTON_H
