#include "pixmapbutton.h"

// PixmapButton

PixmapButton::PixmapButton(qreal minSize, const QPixmap &pixmap, QGraphicsItem *parent)
        : QGraphicsPixmapItem(pixmap, parent)
        , m_minSize(minSize)
{
    setShapeMode(BoundingRectShape);
}

void PixmapButton::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
    emit clicked();
}

QPainterPath PixmapButton::shape() const
{
    return QGraphicsItem::shape();
}

QRectF PixmapButton::boundingRect() const
{
    QRectF result(QGraphicsPixmapItem::boundingRect());
    qreal hMargin = m_minSize < result.width() ? 0 : (m_minSize - result.width()) / 2;
    qreal vMargin = m_minSize < result.height() ? 0 : (m_minSize - result.height()) / 2;
    result.adjust(-hMargin, -vMargin, hMargin, vMargin);
    return result;
}
