/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef _HORIZONTALMENU_H_
#define _HORIZONTALMENU_H_

#include <QtCore>
#include <QtGui>

#include "pixmapwidget.h"
#include "pixmaploader.h"


class HorizontalMenu : public PixmapWidget
{
    Q_OBJECT

public:
    enum Option {
        Food,
        Car,
        House,
        Books,
        Clothes,
        Fun,
        Health,
        Travel,
        Overall
    };

    HorizontalMenu(bool hasOverallIcon = false);
    ~HorizontalMenu();

    QString selected() const;

    int count() const;
    void focusMenuItem(int index, bool animated = true);

signals:
    void optionChanged(QString option);

protected:
    void resizeEvent(QGraphicsSceneResizeEvent *event);

    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

    int indexAtPosition(qreal x);
    void fillWidget(bool hasOverallIcon);

private:
    QGraphicsWidget *w;
    QGraphicsWidget *clipper;
    QGraphicsLinearLayout *l;
    QGraphicsRectItem *marker;
    int selectedIndex;
    int yOffset;
    int markOffset;
    int lightOffset;
    bool isSliding;
    int moveThreshold;
    PixmapWidget *light;
    PixmapWidget *markSelection;

    QSequentialAnimationGroup *sequentialAnimation;

    QPropertyAnimation *centralizeAnimation;
    QPropertyAnimation *fadeAnimation;

    int pressedX;

    QList<QPixmap> selectionPixmaps;

private Q_SLOTS:
    void centralizedStarted();
    void optionSelected();
};

class MenuIconWidget : public PixmapWidget
{
public:
    MenuIconWidget(HorizontalMenu::Option option)
        : PixmapWidget()
    {
        QString filename;
        switch (option) {
            case HorizontalMenu::Food:
                filename = ":/ico_food.png";
                break;
            case HorizontalMenu::Car:
                filename = ":/ico_car.png";
                break;
            case HorizontalMenu::House:
                filename = ":/ico_house.png";
                break;
            case HorizontalMenu::Books:
                filename = ":/ico_books.png";
                break;
            case HorizontalMenu::Clothes:
                filename = ":/ico_clothes.png";
                break;
            case HorizontalMenu::Fun:
                filename = ":/ico_fun.png";
                break;
            case HorizontalMenu::Health:
                filename = ":/ico_health.png";
                break;
            case HorizontalMenu::Travel:
                filename = ":/ico_travel.png";
                break;
            case HorizontalMenu::Overall:
                filename = ":/ico_overall.png";
                break;
            default:
                break;
        }
        setPixmap(PixmapLoader::pixmap(filename));
    }
};

#endif
