/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef CLOCKWIDGET_H
#define CLOCKWIDGET_H

#include <QFont>
#include <QTimer>
#include <QPixmap>
#include <QGraphicsWidget>

class ClockEvent;


class ClockWidget : public QGraphicsWidget
{
    Q_OBJECT

public:
    ClockWidget(QGraphicsItem *parent = 0);
    ~ClockWidget();

    void addEvent(const QDateTime &begin, const QDateTime &end,
                  const QColor &color, const QString &text);

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget = 0);

private slots:
    void updateTime();
    void updateEvents();

private:
    QFont m_dayFont;
    QFont m_labelFont;
    QFont m_weekDayFont;
    QColor m_fontColor;
    QPixmap m_background;
    QPixmap m_divLine;

    QTimer m_timer;
    QPoint m_knobPoint;
    QPoint m_middlePoint;
    QPoint m_labelPos;
    QRectF m_dayRect;
    QRectF m_weekDayRect;
    QRect m_eventsPixmapRect;
    int m_labelHeight;
    int m_eventsInnerOffset;
    int m_eventsInnerDiameter;

    QPixmap m_middleKnob;
    QPixmap m_hourPointer;
    QPixmap m_minutePointer;

    QPixmap m_eventsPixmap;
    QList<ClockEvent *> m_events;
};

#endif
