/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef PHONEVIEW_H
#define PHONEVIEW_H

#include <QTimer>
#include <QPixmap>

#include "view.h"

class Label;
class Overlay;
class CallBoard;
class ContactList;
class DialerWidget;
class DialerDisplay;

QT_BEGIN_NAMESPACE
class QAbstractAnimation;
QT_END_NAMESPACE


class PhoneView : public View
{
    Q_OBJECT

public:
    PhoneView(QGraphicsItem *parent = 0);

signals:
    void callContact();

private:
    void createStateMachine();
    QAbstractAnimation *createCallAnimation();
    QAbstractAnimation *createInCallAnimation();
    QAbstractAnimation *createEndCallAnimation();
    QAbstractAnimation *createInOutAnimation(bool out);
    QAbstractAnimation *createContactAnimation(bool close);

private slots:
    void callClicked();
    void contactClicked(int index);
    void dialButtonClicked(const QString &value);

private:
    QTimer m_callTimer;
    Label *m_label;
    Overlay *m_overlay;
    QGraphicsWidget *m_frame;
    Button *m_callButton;
    Button *m_endCallButton;
    Button *m_contactsButton;
    DialerWidget *m_dialer;
    CallBoard *m_board;
    DialerDisplay *m_display;
    ContactList *m_contactList;
};

#endif
