/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef FORECASTVIEW_H
#define FORECASTVIEW_H

#include <QObject>
#include <QGraphicsItem>
#include <QAbstractAnimation>

#include "forecasthungitem.h"
#include "forecastsnow.h"
#include "forecastrain.h"
#include "forecaststars.h"
#include "forecast.h"

class HungItemsManager
{
public:
    HungItemsManager(qreal minZ, qreal maxZ)
        : m_minZ(minZ)
        , m_maxZ(maxZ)
        , m_displacement(0.0)
        , m_sun(0)
        , m_sunPos(0) {}
    void setSun(ForecastHungItem *sun);
    ForecastHungItem *sun() { return m_sun; }
    void addItem(ForecastHungItem *item);
    QAbstractAnimation *getAnimation();
    void reset();
    void setElementsDisplacement(qreal displacement);
private:
    const qreal m_minZ;
    const qreal m_maxZ;
    qreal m_displacement;
    ForecastHungItem *m_sun;
    qreal m_sunPos;
    QList<ForecastHungItem*> m_items;
    QList<qreal> m_positions;

    void doSetDisplacement(ForecastHungItem *item, qreal max, qreal pos);
};

class EffectAnimation : public QPropertyAnimation
{
    Q_OBJECT
public:
signals:
    void started();
protected:
    void updateState(QAbstractAnimation::State oldState, QAbstractAnimation::State newState)
    {
        if (oldState == Stopped && newState == Running)
            emit started();
    }

private:
};

class ForecastView : public QObject, public QGraphicsItem
{
    Q_OBJECT
    Q_INTERFACES(QGraphicsItem)
public:
    ~ForecastView();
    QRectF boundingRect () const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);
    Forecast::ForecastType viewType() const { return m_type; }
    bool night() const { return m_night; }

    void setElementsDisplacement(qreal displacement);

    void reset();
    QAbstractAnimation *getAnimation();

    static ForecastView *createView(Forecast::ForecastType type, bool night, QGraphicsItem *parent = 0);


protected:
    ForecastView(Forecast::ForecastType type, bool night, QGraphicsItem *parent = 0);

    void addHungItem(ForecastHungItem::ItemType type, const QPointF &itemPos,
                     int deviation, bool reference = false);
    void setMainHangItem(ForecastHungItem::ItemType);
    void addStars();

    void addSnow(int count);
    void addRain(ForecastRain::RainType);

private:
    const Forecast::ForecastType m_type;
    const bool m_night;
    const QRectF m_boundingRect;
    HungItemsManager m_hungManager;
    ForecastStars *m_stars;
    ForecastHungItem *m_reference;
    ForecastRain *m_rain;
    ForecastSnow *m_snow;

    QRectF getEffectRect();
    template<class T> QAbstractAnimation *createEffectAnimation(T *effect);

};

#endif // FORECASTVIEW_H
