/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "forecastrain.h"
#include "settings.h"
#include "pixmaploader.h"

#include <QPainter>

#define RAIN_SLIDE_NUM 5

ForecastRain::ForecastRain(RainType type, QGraphicsItem *parent)
    : QGraphicsObject(parent),
      m_interval(250),
      m_currentFrame(0)
{
    QString prefix = (type == Light) ? "mist_0%1"
        : (type == Medium) ? "rain_0%1" : "storm_0%1";

    for (int i = 1; i <= RAIN_SLIDE_NUM; i++)
        m_slides << PixmapLoader::pixmap(prefix.arg(i));

    connect(&m_timer, SIGNAL(timeout()), SLOT(nextImage()));
}

void ForecastRain::nextImage()
{
    if (++m_currentFrame >= m_slides.length())
        m_currentFrame = 0;

    update();
}

int ForecastRain::loadImages()
{
    for (int i = 1; i <= RAIN_SLIDE_NUM; i++) {
        PixmapLoader::load(QString("rain_0%1").arg(i));
        PixmapLoader::load(QString("mist_0%1").arg(i));
        PixmapLoader::load(QString("storm_0%1").arg(i));
    }
    return RAIN_SLIDE_NUM * 3;
}

void ForecastRain::start()
{
    m_timer.start(m_interval);
}

void ForecastRain::stop()
{
    m_timer.stop();
}

QRectF ForecastRain::boundingRect () const
{
    if (m_slides.isEmpty())
        return QRectF();
    else
        return QRectF(0, 0, m_slides[0].width(), m_slides[0].height());
}

void ForecastRain::paint(QPainter *painter, const QStyleOptionGraphicsItem *opt,
                         QWidget *widget)
{
    Q_UNUSED(opt);
    Q_UNUSED(widget);

    painter->drawPixmap(0, 0, m_slides[m_currentFrame]);
}
