/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef CITYCARROUSSEL_H
#define CITYCARROUSSEL_H

#include "forecast.h"
#include "forecastview.h"
#include "carroussel.h"
#include "cityinfodisplay.h"
#include "forecastdata.h"
#include "citypanel.h"

#include <ImtkLabel>
#include <ImtkFlickableArea>


class ForecastBackground : public QGraphicsPixmapItem
{
public:
    ForecastBackground(QGraphicsItem *parent = 0);
    Forecast::ForecastType forecast() const { return m_forecast; }
    bool night() const { return m_night; }

    void setForecast(Forecast::ForecastType forecast, bool night);
    void reset() { setForecast(Forecast::UnknownForecast, false); }

    void setReferencePos(qreal pos);
    void setDisplacement(qreal displacement);

    void addCompanion(QGraphicsItem *item);
    void removeCompanion(QGraphicsItem *item);

    QString description() const { return m_description; }

private:
    QVariant itemChange(GraphicsItemChange change, const QVariant &value);

private:
    Forecast::ForecastType m_forecast;
    bool m_night;
    qreal m_pos;
    qreal m_displacement;
    QList<QGraphicsItem*> m_companion;

    QGraphicsPixmapItem *m_effect;
    QString m_description;
};


class CityCarroussel : public ImtkFlickableArea
{
    Q_OBJECT
    Q_PROPERTY(qreal displacement READ displacement WRITE setDisplacement)

public:
    CityCarroussel(QGraphicsItem *parent = 0);
    ~CityCarroussel();

    void setFrozen(bool frozen);

    Carroussel<ImtkLabel *> *labels() { return &m_cityLabel; }

    ForecastData currentData() const;
    void setData(QList<ForecastData> items);

    void setCurrentIndex(int index);

    void add(ForecastData item);
    void abort() { m_aborted = true; }

    void updateData();

    static int loadImages();

    bool active() const { return m_active; }
    void setActive(bool value);

    QString selected() const { return m_data.count() > 0 ? m_data[0].key() : QString(); }

public slots:
    void moveLeft() { moveSlide(-1); }
    void moveRight() { moveSlide(1); }

protected:
    void mouseSlideStarted(const QPointF &pos);
    void mouseSlideMoved(const QPointF &pos);
    void mouseSlideFinished(const QPointF &pos);

private:
    bool m_frozen;
    bool m_aborted;
    qreal m_startPoint;

    Carroussel<ForecastData> m_data;
    Carroussel<ForecastBackground*> m_background;
    Carroussel<CityInfoDisplay*> m_cityInfo;
    Carroussel<ImtkLabel *> m_cityLabel;

    CarrousselGroup m_carroussel;
    ForecastView *m_view;
    qreal m_displacement;

    const qreal m_backgroundWidth;
    const qreal m_backgroundPos;
    const qreal m_transparencySize;
    const qreal m_distance;
    qreal m_positions[3];

    bool m_active;
    bool m_deleteAfterMove;

    void setGestureDisplacement(qreal displacement);
    void moveBack() { moveSlide(0); }
    void moveSlide(int direction, bool deleteLastItem = false);
    void moveEnd(int direction);

    void updateBackground(int idx);
    void updateMainItem();

    void setDisplacement(qreal displacement);
    qreal displacement() const { return m_displacement; }

private slots:
    void moveLeftEnd() { moveEnd(-1); }
    void moveRightEnd() { moveEnd(1); }
    void moveBackEnd() { moveEnd(0); }
};

#endif
