/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "widget.h"
#include "widget_p.h"


ImtkWidgetPrivate::ImtkWidgetPrivate(ImtkWidget *qptr)
    : q_ptr(qptr)
{

}


/*!
  \class ImtkWidget
  \brief Base class for all imtk widgets.

  It provides a light-weight foundation for writing your own custom widgets.

  \sa QGraphicsWidget
*/


/*!
  Constructs an ImtkWidget with the given \a parent.
*/
ImtkWidget::ImtkWidget(QGraphicsItem *parent)
    : QGraphicsWidget(parent),
      dd_ptr(new ImtkWidgetPrivate(this))
{

}

/*!
  \internal

  Constructs an ImtkWidget with a given d-pointer and a parent.
*/
ImtkWidget::ImtkWidget(ImtkWidgetPrivate &dptr, QGraphicsItem *parent)
    : QGraphicsWidget(parent), dd_ptr(&dptr)
{

}

/*!
  Destroys a ImtkWidget.
*/
ImtkWidget::~ImtkWidget()
{
    delete dd_ptr;
}
