/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "utils.h"
#include "yahooweatherresponse.h"


struct ConditionTypeData
{
    const int id;
    Forecast::ForecastType type;
};

static const int ContitionTypeCount = 47;
static const ConditionTypeData ContitionType[ContitionTypeCount] = {
    {1, Forecast::Storm},
    {2, Forecast::Thunderstorm},
    {3, Forecast::Thunderstorm},
    {4, Forecast::Thunderstorm},
    {5, Forecast::Sleet},
    {6, Forecast::Rain},
    {7, Forecast::Sleet},
    {8, Forecast::Mist},
    {9, Forecast::Mist},
    {10, Forecast::Rain},
    {11, Forecast::Rain},
    {12, Forecast::Rain},
    {13, Forecast::Flurries},
    {14, Forecast::Flurries},
    {15, Forecast::Snow},
    {16, Forecast::Snow},
    {17, Forecast::Snow},
    {18, Forecast::Sleet},
    {19, Forecast::Haze},
    {20, Forecast::Fog},
    {21, Forecast::Haze},
    {22, Forecast::Fog},
    {23, Forecast::Cloudy},
    {24, Forecast::Cloudy},
    {25, Forecast::Cloudy},
    {26, Forecast::Cloudy},
    {27, Forecast::MostlyCloudy},
    {28, Forecast::MostlyCloudy},
    {29, Forecast::PartlyCloudy},
    {30, Forecast::PartlyCloudy},
    {31, Forecast::Sunny},
    {32, Forecast::Sunny},
    {33, Forecast::MostlySunny},
    {34, Forecast::MostlySunny},
    {35, Forecast::Sleet},
    {36, Forecast::Sunny},
    {37, Forecast::Thunderstorm},
    {38, Forecast::Thunderstorm},
    {39, Forecast::Thunderstorm},
    {40, Forecast::Storm},
    {41, Forecast::Snow},
    {42, Forecast::Sleet},
    {43, Forecast::Snow},
    {44, Forecast::PartlyCloudy},
    {45, Forecast::Thunderstorm},
    {46, Forecast::Sleet},
    {47, Forecast::Thunderstorm}
};

static Forecast::ForecastType translateCode(const QString &value)
{
    int code = strToInt(value, 3200);
    for (int i = 0; i < ContitionTypeCount; i++)
        if (ContitionType[i].id == code)
            return ContitionType[i].type;
    return Forecast::UnknownForecast;
}

YahooWeatherResponse::YahooWeatherResponse(const QString &locationCode,
                                           const QDomElement &element)
    : WeatherResponse(locationCode)
{
    parseDocument(element);
}

void YahooWeatherResponse::parseDocument(const QDomElement &element)
{
    const QDomNodeList &channels = element.elementsByTagName("channel");
    if (channels.count() == 0)
        return;

    QDomElement channel = channels.item(0).toElement();
    for (int i = 0; i < channel.childNodes().count(); ++i) {
        QDomNode node = channel.childNodes().at(i);

        if (node.nodeName() == "lastBuildDate")
            buildDate = readDateTime(getNodeContentText(node));

        if (node.nodeName() == "ttl")
            timeToLive = strToInt(getNodeContentText(node), 30);

        if (node.nodeName() == "yweather:location") {
            QDomElement element = node.toElement();
            location.city = element.attribute("city");
            location.region = element.attribute("region");
            location.country = element.attribute("country");
        }

        if (node.nodeName() == "yweather:astronomy") {
            QDomElement element = node.toElement();
            astronomy.sunrise = QTime::fromString(element.attribute("sunrise"), "h:mm ap");
            astronomy.sunset = QTime::fromString(element.attribute("sunset"), "h:mm ap");
        }

        if (node.nodeName() == "item")
            readItem(node.toElement());

    }
}

void YahooWeatherResponse::readItem(const QDomElement &item)
{
    int idx = 0;
    for (int i = 0; i < item.childNodes().count(); ++i) {
        QDomNode node = item.childNodes().at(i);
        if (node.nodeName() == "pubDate")
            pubDate = readDateTime(getNodeContentText(node));

        if (node.nodeName() == "yweather:condition") {
            QDomElement element = node.toElement();

            condition.text = element.attribute("text");
            condition.temperature = strToInt(element.attribute("temp"), 0);
            condition.date = readDateTime(element.attribute("date"));

            // translate to native type
            condition.code = translateCode(element.attribute("code"));
        }

        if (node.nodeName() == "yweather:forecast") {
            QDomElement element = node.toElement();

            if (idx++ == 0) {
                forecast1.date = QDate::fromString(element.attribute("date"), "dd MMM yyyy");
                forecast1.low = strToInt(element.attribute("low"), 0);
                forecast1.high = strToInt(element.attribute("high"), 0);
                forecast1.text = element.attribute("text");
                forecast1.code = translateCode(element.attribute("code"));
                forecast1.valid = true;
            } else {
                WeatherResponse::WeekForecast f;
                f.date = QDate::fromString(element.attribute("date"), "dd MMM yyyy");
                f.low = strToInt(element.attribute("low"), 0);
                f.high = strToInt(element.attribute("high"), 0);
                f.text = element.attribute("text");
                f.code = translateCode(element.attribute("code"));
                f.valid = true;

                forecasts << f;
            }
        }

        idx = idx > 1 ? 0 : idx;
    }
}

bool YahooWeatherResponse::isNight() const
{
    return condition.date.time() < astronomy.sunrise
        || condition.date.time() > astronomy.sunset;
}
