/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QDir>

#include "model.h"


ImtkAbstractModel::ImtkAbstractModel(QObject *parent)
    : QObject(parent)
{

}



ImtkStandardModel::ImtkStandardModel(QObject *parent)
    : ImtkAbstractModel(parent)
{

}

int ImtkStandardModel::count() const
{
    return m_items.count();
}

void ImtkStandardModel::clear()
{
    m_items.clear();
    emit updated();
}

void ImtkStandardModel::insert(int index, const QHash<QString, QVariant> &values)
{
    m_items.insert(index, values);
    emit itemAdded(index);
}

void ImtkStandardModel::remove(int index)
{
    if (index >= 0 && index < m_items.count()) {
        m_items.removeAt(index);
        emit itemRemoved(index);
    }
}

void ImtkStandardModel::move(int from, int to)
{
    if (from >= 0 && from < m_items.count() && to >= 0 && to < m_items.count()) {
        QHash<QString, QVariant> values = m_items[from];
        m_items.removeAt(from);
        m_items.insert(to, values);

        emit itemMoved(from, to);
    }
}

void ImtkStandardModel::append(const QHash<QString, QVariant> &values)
{
    m_items.append(values);
    emit itemAdded(m_items.count() - 1);
}

QVariant ImtkStandardModel::data(int index, const QString &role) const
{
    return m_items[index].value(role);
}

void ImtkStandardModel::setData(int index, const QString &role, const QVariant &value)
{
    m_items[index][role] = value;
    itemChanged(index);
}

void ImtkStandardModel::setData(int index, const QHash<QString, QVariant> &values)
{
    m_items[index] = values;
    itemChanged(index);
}
