//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsweather.h"
#include <QTimer>

LsWeather::LsWeather(QString name) :
        LsWidget(name.isEmpty() ? "Weather": name)
{
    m_Process = NULL;
    m_UpdateTimer = NULL;

    applySettings();
#ifdef Q_WS_MAEMO_5
    QDBusConnection::systemBus().connect("com.nokia.icd", "/com/nokia/icd", "com.nokia.icd",
                                         "status_changed", this, SLOT(netStateChanged(QString,QString,QString,QString)));
#endif
}


void LsWeather::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
                      QWidget*)
{
    if (!m_Image.isNull()){
        painter->drawPixmap(0,0,m_Image);
    }
}

void LsWeather::applySettings()
{
    int interval = getSetting("AutoUpdateIntervalSeconds", 0).toInt();
    if (interval > 0){
        if (m_UpdateTimer){
            m_UpdateTimer->stop();
            delete m_UpdateTimer;
            m_UpdateTimer = NULL;
        }
        m_UpdateTimer = new QTimer(this);
        connect(m_UpdateTimer, SIGNAL(timeout()), this, SLOT(updateWeather()));
        m_UpdateTimer->setInterval(interval*1000);
        m_UpdateTimer->setSingleShot(false);
        m_UpdateTimer->start();
    }

    m_CurrentText = getSetting("CurrentText", "").toString();
    m_CurrentPos = getPosSetting("CurrentPos", QPoint(160,60));
    m_CurrentFont = getFontSetting("CurrentFont", QFont("", 40, QFont::Normal, false));
    m_CurrentColor = getColorSetting("CurrentColor", QColor(255,255,255));

    m_HighText = getSetting("HighText", tr("High:")).toString();
    m_HighPos = getPosSetting("HighPos", QPoint(170,90));
    m_HighFont = getFontSetting("HighFont", QFont("", 14, QFont::Normal, false));
    m_HighColor = getColorSetting("HighColor", QColor(255,255,255));

    m_LowText = getSetting("LowText", tr("Low:")).toString();
    m_LowPos = getPosSetting("LowPos", QPoint(170,110));
    m_LowFont = getFontSetting("LowFont", QFont("", 14, QFont::Normal, false));
    m_LowColor = getColorSetting("HighColor", QColor(255,255,255));

    m_MinimumSecs = getSetting("MinimumSecondsBetweenUpdates", 1200).toInt();
    m_Link = getSetting("Link", "italy/lombardy/milan-718345").toString();
    m_Unit = getSetting("Unit", "c").toString();

    setSizeAndPosition(QSize(300, 150), QPoint(0, 0));
}

void LsWeather::stopUpdate()
{
#ifdef Q_WS_MAEMO_5
    if (m_Process != NULL)
        m_Process->kill();
#endif
}

void LsWeather::startUpdate()
{
#ifdef Q_WS_MAEMO_5    
    if (!m_LastUpdate.isValid())
        QTimer::singleShot(500, this, SLOT(updateWeather()));
#else
    QTimer::singleShot(500, this, SLOT(updateWeather()));
#endif
}

void LsWeather::netStateChanged(QString, QString type, QString state, QString)
{
    qDebug() << QString("Network status changed: %1 %2").arg(type).arg(state);
    if (type == "WLAN_INFRA" || type == "GPRS"){
        if (state == "CONNECTED"){
            updateWeather();
        }else if (state == "DISCONNECTING"){
            if (m_Process != NULL)
                m_Process->kill();
        }
    }
}

void LsWeather::updateWeather()
{
    if (m_Process != NULL ||
       (m_LastUpdate.isValid() && m_LastUpdate.secsTo(QDateTime::currentDateTime()) <= m_MinimumSecs))
        return;

    qDebug() << "Updating weather informations";
    QString link = QString("http://weather.yahoo.com/%1").arg(m_Link);
    if (!m_Unit.isEmpty())
        link.append(QString("?unit=%1").arg(m_Unit));

    QString command = QString("/opt/qtlockscreen/weatherwidget.sh %1").arg(link);
    m_Process = new QProcess(this);
    m_Process->start(command, QIODevice::ReadOnly);
    if (m_Process->waitForFinished()){
        if (m_Process->exitCode() == 0){
            m_Image = QPixmap(size().width(), size().height());
            m_Image.fill(QColor(0,0,0,0));

            QImage tImage = QImage("/tmp/ywtemp.png");
            QPainter painter(&m_Image);
            if (!tImage.isNull())
                painter.drawImage(0,0, tImage);

            QString output = QString(m_Process->readAll());
            qDebug() << "Weather widget command output:" << output;
            m_LastUpdate = QDateTime::currentDateTime();

            QStringList lines = output.split("\n");
            foreach (QString l, lines){
                l = l.toLower();
                QStringList ele = l.split(" ", QString::SkipEmptyParts);
                if (ele.count() == 2){
                    int val = ele.at(1).toInt();
                    QString temp;
                    if (ele.at(0) == "current:"){
                        temp = QString("%1 %2").arg(m_CurrentText).arg(val);
                        painter.setFont(m_CurrentFont);
                        painter.setPen(m_CurrentColor);
                        painter.drawText(m_CurrentPos.x(), m_CurrentPos.y(), temp);
                    }else if (ele.at(0) == "high:"){
                        temp = QString("%1 %2").arg(m_HighText).arg(val);
                        painter.setFont(m_HighFont);
                        painter.setPen(m_HighColor);
                        painter.drawText(m_HighPos.x(), m_HighPos.y(), temp);
                    }else if (ele.at(0) == "low:"){
                        temp = QString("%1 %2").arg(m_LowText).arg(val);
                        painter.setFont(m_LowFont);
                        painter.setPen(m_LowColor);
                        painter.drawText(m_LowPos.x(), m_LowPos.y(), temp);
                    }
                }
            }

            update();
        }else
            qDebug() << "  Process exited with code" << m_Process->exitCode();
    }else
        qDebug() << "  Failed to wait for process to finish";

    delete m_Process;
    m_Process = NULL;
}
