//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lstext.h"

LsText::LsText(QString name) :
        LsWidget(name.isEmpty() ? "Text": name)
{
    applySettings();
}

void LsText::applySettings()
{
    m_Alignment = getAlignmentSetting("Alignment", Qt::AlignHCenter);
    m_Color = getColorSetting("Color", QColor(255,255,255));
    m_Font = getFontSetting("Font", QFont("", 30, QFont::Normal, false));
    m_Text = getSetting("Text", "").toString();

    QFontMetrics fm(m_Font);
    QSize size = fm.size(Qt::TextSingleLine, m_Text);

    QRectF defSize(0,0, size.width(), size.height() + MINIMUM_TEXT_MARGIN);
    setSizeAndPosition(QSize(defSize.width(), defSize.height()), QPoint(0, 0));
}

void LsText::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    painter->setFont(m_Font);
    painter->setPen(m_Color);
    painter->drawText(boundingRect(), Qt::AlignTop | m_Alignment | Qt::TextSingleLine, m_Text);
}
