//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lscommandbutton.h"

LsCommandButton::LsCommandButton(QString name) :
        LsButton(name.isEmpty() ? "CommandButton": name)
{
    m_Process = NULL;
    applySettings();
}

void LsCommandButton::applySettings()
{
    m_Command = getSetting("Command", "").toString();
    m_Bkg = QPixmap(getSetting("BackGroundImage", "/opt/qtlockscreen/default/forward.png").toString());
    m_BkgPressed = QPixmap(getSetting("BackGroundImagePressed", "/opt/qtlockscreen/default/forwardPressed.png").toString());
    m_BkgPressed = m_BkgPressed.scaled(m_Bkg.size());

    setSizeAndPosition(m_Bkg.size(), QPoint(0, 0));
}

void LsCommandButton::clicked()
{
    qDebug() << "Button " << name() << "clicked";
    if (!m_Command.isEmpty() && (m_Process == NULL || m_Process->state() == QProcess::NotRunning)){
        if (m_Process){
            delete m_Process;
            m_Process = NULL;
        }
        qDebug() << "Command: " << m_Command;
        m_Process = new QProcess(this);
        connect(m_Process, SIGNAL(finished(int,QProcess::ExitStatus)), this, SLOT(onProcessFinished(int,QProcess::ExitStatus)));
        m_Process->start(m_Command, QIODevice::ReadOnly);
    }
}

void LsCommandButton::onProcessFinished(int exitCode, QProcess::ExitStatus)
{
    qDebug() << "Process exit code:" << exitCode;
}
