//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsprofile.h"
#include "lockscreen.h"

LsProfile::LsProfile(QString name) :
        LsImage(name.isEmpty() ? "Profile": name)
{
    m_Profile = new SystemProfiles(this);
    applySettings();

    if (LockScreen::Debug){
        m_ProfileName = "silent";
        setImage();
    }

#ifdef Q_WS_MAEMO_5
    m_ProfileName = "";
#else
    m_ProfileName = "silent";
    setImage();
#endif
}

void LsProfile::applySettings()
{
    m_Images.clear();
    QString images = getSetting("Images", "silent=/opt/qtlockscreen/default/profile_silent.png").toString();
    QStringList lst = images.split(";", QString::SkipEmptyParts);
    foreach (const QString image, lst){
        QStringList ele = image.split("=", QString::SkipEmptyParts);
        if (ele.count() >= 2){
            m_Images[ele.at(0)] = ele.at(1);
        }
    }

    setSizeAndPosition(QSize(24, 24),QPoint(0, 0));
}

void LsProfile::startUpdate()
{
#ifdef Q_WS_MAEMO_5
    if (!LockScreen::Debug)
        getCurrentProfile();
    connect(m_Profile, SIGNAL(profileChanged(QString)), this, SLOT(profileChangedSlot(QString)));
#endif
}

void LsProfile::stopUpdate()
{
#ifdef Q_WS_MAEMO_5
    disconnect(m_Profile, SIGNAL(profileChanged(QString)), this, SLOT(profileChangedSlot(QString)));
#endif
}

void LsProfile::getCurrentProfile()
{
    m_ProfileName = m_Profile->currentProfile();
    qDebug() << "Current profile:" << m_ProfileName;
    setImage();
}

void LsProfile::profileChangedSlot(QString profileName)
{
    qDebug() << "Profile changed:" << profileName;
    m_ProfileName = profileName;
    setImage();
}

void LsProfile::setImage()
{
    if (m_Images.contains(m_ProfileName)){
        QString file = m_Images[m_ProfileName];
        m_Image = QPixmap(file);
    }else{
        m_Image = QPixmap();
    }
}
