//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsdatetime.h"
#include <QDateTime>

LsDateTime::LsDateTime(QString name):
        LsWidget(name.isEmpty() ? "DateTime": name)
{
    applySettings();
    connect(&m_Timer, SIGNAL(timeout()), this, SLOT(timerSlot()));
    m_Timer.setInterval(500);
    m_Timer.setSingleShot(false);    
}

void LsDateTime::applySettings()
{
    m_Alignment = getAlignmentSetting("Alignment", Qt::AlignHCenter, Qt::AlignTop);
    QDateTime now = QDateTime::currentDateTime();

    m_TimeColor = getColorSetting("TimeColor", QColor(255,255,255));
    m_DateColor = getColorSetting("DateColor", QColor(255,255,255));

    m_DateFormat = getSetting("DateFormat", "dd/MM/yyyy").toString();
    m_TimeFormat = getSetting("TimeFormat", "hh:mm").toString();
    if (m_TimeFormat.contains("s"))
        m_Timer.setInterval(500);
    else
        m_Timer.setInterval(2000);

    m_TimeFont = getFontSetting("TimeFont", QFont("", 30, QFont::Normal, false));

    QFontMetrics fm(m_TimeFont);
    QSize size = fm.size(Qt::TextSingleLine, QLocale().toString(now, m_TimeFormat));

    QRectF defSize(0,0, size.width(), size.height() + MINIMUM_TEXT_MARGIN);

    m_DateFont = getFontSetting("DateFont", QFont("", 12, QFont::Normal, false));
    fm = QFontMetrics(m_DateFont);
    size = fm.size(Qt::TextSingleLine, QLocale().toString(now, m_DateFormat));
    defSize.setHeight(defSize.height() + size.height());
    if (size.width() > defSize.width())
        defSize.setWidth(size.width());

    setSizeAndPosition(QSize(defSize.width(), defSize.height()), QPoint(0, 0));
}

void LsDateTime::paint(QPainter *painter, const QStyleOptionGraphicsItem* option, QWidget *)
{
    painter->setClipRect(option->exposedRect);
    QDateTime now = QDateTime::currentDateTime();

    painter->setFont(m_TimeFont);
    painter->setPen(m_TimeColor);
    painter->drawText(boundingRect(), m_Alignment | Qt::TextSingleLine, m_TimeString);

    painter->setFont(m_DateFont);
    painter->setPen(m_DateColor);
    QRectF dateRect(boundingRect());
    QFontMetrics fm(m_TimeFont);
    dateRect.setTop(dateRect.top() + fm.size(Qt::TextSingleLine, m_DateString).height() + MINIMUM_TEXT_MARGIN);
    painter->drawText(dateRect, m_Alignment | Qt::TextSingleLine, m_DateString);
}

void LsDateTime::timerSlot()
{
    QDateTime now = QDateTime::currentDateTime();
    QString time = QLocale().toString(now, m_TimeFormat);
    QString date = QLocale().toString(now, m_DateFormat);
    if (time != m_TimeString || date != m_DateString){
        m_TimeString = time;
        m_DateString = date;
        update();
    }
}

void LsDateTime::stopUpdate()
{
    m_Timer.stop();
}

void LsDateTime::startUpdate()
{
    if (!m_Timer.isActive()){
        timerSlot();
        m_Timer.start();
    }
}
