/* --------------------------------------------------------------------------------------------
Copyright 2009 Robin Nilsson <robinnilsson@gmail.com>. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are
permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright notice, this list
      of conditions and the following disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Robin Nilsson ``AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Robin Nilsson OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those of the
authors and should not be interpreted as representing official policies, either expressed
or implied, of Robin Nilsson.
------------------------------------------------------------------------------------------- */

#ifndef DESPOTIFYPLAY_H
#define DESPOTIFYPLAY_H

#include "despotify_cpp.h"

#include <QDebug>
#include <QThread>
#include <QMutex>

#include "audio.h"

enum e_play_state {
    PAUSE,
    PLAY,
    EXIT
};

class DespotifyPlay : public QThread {
    Q_OBJECT

private:

    e_play_state play_state;
    e_play_state last_state;

    despotify_session* ds;
    ao_device* ao;

    QMutex mutex;

public:
    DespotifyPlay(despotify_session* _ds,ao_device* _ao);
    virtual void run();
    void Exit(void);
    void PlayPause(void);
    void Pause(void);
    void NewSong(despotify_session* ds, track* t, bool play_as_list);

signals:
    void Playing();
    void Paused();
    void Exiting();
};

#endif // DESPOTIFYPLAY_H
